% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writetif.R
\name{writeTIF}
\alias{writeTIF}
\title{Writes image stack into a TIFF file.
Wrapper for writeTIFF}
\usage{
writeTIF(img, file, bps = attributes(img)$bits.per.sample, twod = FALSE,
  reduce = TRUE, attr = attributes(img), compression = "none")
}
\arguments{
\item{img}{An image, a 3d or 4d array.}

\item{file}{File name.}

\item{bps}{number of bits per sample (numeric scalar). Supported values in this version are 8, 16, and 32.}

\item{twod}{Dimension of channels. TRUE for 2d images, FALSE for 3d images.}

\item{reduce}{if TRUE then writeTIFF will attempt to reduce the number of planes in native rasters by analyzing the image to choose one of RGBA, RGB, GA or G formats, whichever uses the least planes without any loss. Otherwise the image is always saved with four planes (RGBA).}

\item{attr}{Attributes of image stack. Will be propagated to each 2d image.}

\item{compression}{(see ?writeTIFF)}
}
\description{
Writes image stack into a TIFF file.
Wrapper for writeTIFF
}
