% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pasteLoc}
\alias{pasteLoc}
\title{Get coordinates on plot}
\usage{
pasteLoc(nb, digits = c(3, 3))
}
\arguments{
\item{nb}{Number of positions.}

\item{digits}{2 integer indicating the number of decimal places
(respectively for x and y coordinates).}
}
\value{
A list of coordinates. Note that if you don't put the result in a
variable, it returns as the command text for generating the list. This can
be useful to get coordinates by mouse-clicking once, but then using the code
for convenience and reproducibility.
}
\description{
Get coordinates on a plot by mouse-clicking.
}
\examples{
\dontrun{
plot(runif(20, max = 5000))
# note the negative number for the rounding of $y
coord <- pasteLoc(3, digits = c(2, -1))
text(coord, c("a", "b", "c"))
}
}
