% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-r-sq-beta-sandwich.R
\name{RSqBetaSandwich}
\alias{RSqBetaSandwich}
\title{Estimate Multiple Correlation Coefficients
(R-squared and adjusted R-squared)
and the Corresponding Sampling Covariance Matrix}
\usage{
RSqBetaSandwich(object)
}
\arguments{
\item{object}{Object of class \code{betasandwich},
that is,
the output of the \code{BetaHC()}, \code{BetaN()}, or \code{BetaADF()} functions.}
}
\value{
Returns an object of class \code{rsqbetasandwich}
which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{fit}{The argument \code{object}.}
\item{vcov}{Sampling covariance matrix of
multiple correlation coefficients
(R-squared and adjusted R-squared).}
\item{est}{Vector of multiple correlation coefficients
(R-squared and adjusted R-squared).}
}
}
\description{
Estimate Multiple Correlation Coefficients
(R-squared and adjusted R-squared)
and the Corresponding Sampling Covariance Matrix
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
rsq <- RSqBetaSandwich(std)
# Methods -------------------------------------------------------
print(rsq)
summary(rsq)
coef(rsq)
vcov(rsq)
confint(rsq, level = 0.95)
}
\seealso{
Other Beta Sandwich Functions: 
\code{\link{BetaADF}()},
\code{\link{BetaHC}()},
\code{\link{BetaN}()},
\code{\link{DiffBetaSandwich}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Sandwich Functions}
\keyword{betaSandwich}
\keyword{rsq}
