% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trees_filenames.R
\name{get_trees_filenames}
\alias{get_trees_filenames}
\title{Get the .trees filenames that BEAST2 will produce}
\usage{
get_trees_filenames(input_filename)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.}
}
\value{
character vector with the names of the .trees files that BEAST2
  will produce
}
\description{
Get the .trees filenames that BEAST2 will produce
}
\examples{
  library(testthat)

  expect_equal(
    get_trees_filenames(get_beastier_path("2_4.xml")),
    "test_output_0.trees"
  )

  expect_equal(
    get_trees_filenames(get_beastier_path("anthus_2_4.xml")),
    c("Anthus_nd2.trees", "Anthus_aco.trees")
  )
}
\author{
Richèl J.C. Bilderbeek
}
