##########.txt output
options(warn=-1)
GLMoutput<-function(RefData, TestData,TotalData)
{
filepath<-getwd()
cat("\n")
cat("****************************************************************************\n")
cat(" Files have been output to the directory of                                 \n")
cat(" ",filepath,"\n")
cat("*--------------------------------------------------------------------------*\n")
cat("* 1. ANOVA_stat.txt                                                        *\n")
cat("*    -->GLM:Cmax, AUC0t, AUC0inf, Ln(Cmax), Ln(AUC0t), Ln(AUC0inf)         *\n")
cat("*    -->90%CI: Ln(Cmax), Ln(AUC0t), and Ln(AUC0inf)                        *\n")
cat("****************************************************************************\n")
cat("\n")


#GLM_Cmax.txt
zz <- file("ANOVA_stat.txt", open="wt")
sink(zz)
cat("~~~  This report is generated by Bear v1.1.5 for R ~~~\n")
cat("Authors: Hsin-ya Lee, Yung-jin Lee\n")
cat("#100, Shih-chuan 1st Rd.\n")
cat("College of Pharmacy,\n")
cat("Kaohsiung Medical University,\n")
cat("Kaoshiung, Taiwan 80708\n")
cat("E-mail: hsinyalee@gmail.com,\n") 
cat("        pkpd.taiwan@gmail.com \n")
cat("bear's website: http://pkpd.kmu.edu.tw/bear\n")
cat("R website: www.r-project.org\n")
cat("-------------------------------------------------------------------------\n")
cat("\n")
cat("\n")
cat("\n")
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: Cmax                                                 \n")
cat("\n")
cat("Type I SS\n")
Cmax<- lm(Cmax ~ seq + subj:seq + prd + drug , data=TotalData)
show(anova(Cmax)) 
cat("\n")
cat("Type III SS\n")
show(drop1(Cmax, test="F"))
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(Cmax ~ prd*drug + Error(subj) , data=TotalData)))
cat("\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_AUC0t.txt
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: AUC0t                                                \n")
cat("\n")
cat("Type I SS\n")
AUC0t<- lm(AUC0t ~ seq + subj:seq+ prd + drug , data=TotalData)
show(anova(AUC0t))
cat("\n")
cat("Type III SS\n")
show(drop1(AUC0t, test="F"))
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(AUC0t ~ prd*drug + Error(subj) , data=TotalData)))
cat("\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_AUC0INF.txt
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: AUC0inf                                             \n")
cat("\n")
cat("Type I SS\n")
AUC0INF<- lm(AUC0INF ~ seq + subj:seq + prd + drug , data=TotalData)
show(anova(AUC0INF))
cat("\n")
cat("Type III SS\n")
show(drop1(AUC0INF, test="F")) 
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(AUC0INF ~ prd*drug + Error(subj) , data=TotalData)))
cat("\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_LnCmax.txt
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: LnCmax                                               \n")
cat("\n")
cat("Type I SS\n")
LnCmax<- lm(LnCmax ~ seq + subj:seq + prd + drug , data=TotalData)
show(anova(LnCmax))
cat("\n")
cat("Type III SS\n")
show(drop1(LnCmax, test="F"))
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(LnCmax ~ prd*drug + Error(subj) , data=TotalData)))  
cat("\n")
cat("Intra_subject CV=100*sqrt(MSResidual)=",100*sqrt(anova(LnCmax)[5,3]),"%\n")
cat("Inter_subject CV=100*sqrt((MSSubject(seq)-MSResidual)/2)=",100*sqrt(abs(anova(LnCmax)[2,3]-anova(LnCmax)[5,3])/2),"%\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_LnAUC0t.txt
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: LnAUC0t                                               \n")
cat("\n")
cat("Type I SS\n")
LnAUC0t<- lm(LnAUC0t ~ seq + subj:seq + prd + drug , data=TotalData)
show(anova(LnAUC0t))
cat("\n")
cat("Type III SS\n")
show(drop1(LnAUC0t, test="F")) 
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(LnAUC0t ~ prd*drug + Error(subj) , data=TotalData))) 
cat("\n")
cat("Intra_subject CV=100*sqrt(MSResidual)=",100*sqrt(anova(LnAUC0t)[5,3]),"%\n")
cat("Inter_subject CV=100*sqrt((MSSubject(seq)-MSResidual)/2)=",100*sqrt(abs(anova(LnAUC0t)[2,3]-anova(LnAUC0t)[5,3])/2),"%\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_AUC0INF.txt
cat("                           ANOVA (lm) Procedure                           \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: LnAUC0inf                                             \n")
cat("\n")
cat("Type I SS\n")
LnAUC0INF<- lm(LnAUC0INF ~ seq + subj:seq + prd + drug , data=TotalData)
show(anova(LnAUC0INF))
cat("\n")
cat("Type III SS\n")
show(drop1(LnAUC0INF, test="F")) 
cat("\n")
cat("Tests of Hypothesis for SUBJECT(SEQUENCE) as an error term\n")
print(summary(aov(LnAUC0INF ~ prd*drug + Error(subj) , data=TotalData))) 
cat("\n")
cat("Intra_subject CV=100*sqrt(MSResidual)=",100*sqrt(anova(LnAUC0INF)[5,3]),"%\n")
cat("Inter_subject CV=100*sqrt((MSSubject(seq)-MSResidual)/2)=",100*sqrt(abs(anova(LnAUC0INF)[2,3]-anova(LnAUC0INF)[5,3])/2),"%\n")
cat("\n")
cat("\n")
cat("\n")

########################################################################################## 
########REPORT
#L1(Reference-->Test),L2(Test-->Reference sequence)
SeqLeg<-split(RefData, list(RefData$seq))
L1<-length(SeqLeg[[1]]$seq)
L2<-length(SeqLeg[[2]]$seq)
T<-qt(0.95,(L1+L2-2))

ref_Cmax<-mean(RefData$LnCmax)
ref_AUC0t<-mean(RefData$LnAUC0t)
ref_AUC0INF<-mean(RefData$LnAUC0INF)

test_Cmax<-mean(TestData$LnCmax)
test_AUC0t<-mean(TestData$LnAUC0t)
test_AUC0INF<-mean(TestData$LnAUC0INF)

SE_Cmax<-sqrt((anova(LnCmax)[5,3]/2) * (1/L1+1/L2))
SE_AUC0t<-sqrt((anova(LnAUC0t)[5,3]/2) * (1/L1+1/L2))
SE_AUC0INF<-sqrt((anova(LnAUC0INF)[5,3]/2) * (1/L1+1/L2))

Z_Cmax<-0.2*(ref_Cmax/SE_Cmax)-qnorm(0.95)
Z_AUC0t<-0.2*(ref_AUC0t/SE_AUC0t)-qnorm(0.95)
Z_AUC0INF<-0.2*(ref_AUC0INF/SE_AUC0INF)-qnorm(0.95)

T_Cmax<-0.2*(ref_Cmax/SE_Cmax)-qt(0.975,L1+L2-2)
T_AUC0t<-0.2*(ref_AUC0t/SE_AUC0t)-qt(0.975,L1+L2-2)
T_AUC0INF<-0.2*(ref_AUC0INF/SE_AUC0INF)-qt(0.975,L1+L2-2)

lowerCmax<-100*exp((test_Cmax-ref_Cmax)-(T*SE_Cmax))
upperCmax<-100*exp((test_Cmax-ref_Cmax)+(T*SE_Cmax))
lowerAUC0t<-100*exp((test_AUC0t-ref_AUC0t)-(T*SE_AUC0t))
UpperAUC0t<-100*exp((test_AUC0t-ref_AUC0t)+(T*SE_AUC0t))
LowerAUC0INF<-100*exp((test_AUC0INF - ref_AUC0INF)-(T*SE_AUC0INF))
UpperAUC0INF<-100*exp((test_AUC0INF - ref_AUC0INF)+(T*SE_AUC0INF))
#Report_LnAUC0t.txt

cat("\n")
cat("\n")
cat("                             BE Summary Report                            \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: LnCmax                                               \n")
cat("--------------------------------------------------------------------------\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_Cmax, "\n")
cat("LSM-test=",test_Cmax, "\n")
cat("MSE=",anova(LnCmax)[5,3], "\n")
cat("SE=",SE_Cmax, "\n")
cat("Diff. (test-ref)=", test_Cmax-ref_Cmax, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_Cmax, "\n")
cat("Power(1-beta)_Z=", pnorm(abs(Z_Cmax)),"\n")
cat("t(beta)=",T_Cmax, "\n")
cat("Power(1-beta)_t=", pt(T_Cmax,L1+L2-2) ,"\n")
cat("\n")
cat("************************90% C.I. for LnCmax********************************\n")
cat("90% CI Lower=", round(lowerCmax,3) ,"\n")
cat("90% CI Upper=", round(upperCmax,3) ,"\n")
cat("--------------------------------------------------------------------------\n")
cat("\n")
cat("\n")
cat("\n")
cat("\n")

#GLM_LnAUC0t.txt

cat("                             BE Summary Report                            \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: LnAUC0t                                               \n")
cat("--------------------------------------------------------------------------\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_AUC0t, "\n")
cat("LSM-test=",test_AUC0t, "\n")
cat("MSE=",anova(LnAUC0t)[5,3], "\n")
cat("SE=",SE_AUC0t, "\n")
cat("Diff. (test-ref)=", test_AUC0t-ref_AUC0t, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_AUC0t, "\n")
cat("Power(1-beta)_Z=", pnorm(abs(Z_AUC0t)),"\n")
cat("t(beta)=",T_AUC0t, "\n")
cat("Power(1-beta)_t=",pt(T_AUC0t,L1+L2-2),"\n")
cat("\n")
cat("************************90% C.I. for LnAUC0t*******************************\n")
cat("90% CI Lower=", round(lowerAUC0t,3) ,"\n")
cat("90% CI Upper=", round(UpperAUC0t,3) ,"\n")
cat("--------------------------------------------------------------------------\n")
cat("\n")
cat("\n")
cat("\n")
cat("\n")

#Report_AUC0INF.txt

cat("                             BE Summary Report                            \n")
cat("--------------------------------------------------------------------------\n")
cat("  Dependent Variable: AUC0inf                                             \n")
cat("--------------------------------------------------------------------------\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_AUC0INF, "\n")
cat("LSM-test=",test_AUC0INF, "\n")
cat("MSE=",anova(LnAUC0INF)[5,3], "\n")
cat("SE=",SE_AUC0INF, "\n")
cat("Diff. (test-ref)=", test_AUC0INF - ref_AUC0INF, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_AUC0INF, "\n")
cat("Power(1-beta)_Z=",pnorm(abs(Z_AUC0INF)),"\n")
cat("t(beta)=",T_AUC0INF, "\n")
cat("Power(1-beta)_t=",pt(T_AUC0INF,L1+L2-2),"\n")
cat("\n")
cat("************************90% C.I. for LnAUC0inf*****************************\n")
cat("90% CI Lower=", round(LowerAUC0INF,3) ,"\n")
cat("90% CI Upper=", round(UpperAUC0INF,3) ,"\n")
cat("--------------------------------------------------------------------------\n")
cat("\n")
cat("\n")
cat("\n")
cat("\n")
sink()

}