% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dm_Rdate_Eti}
\alias{dm_Rdate_Eti}
\title{Make etiology design matrix for dates with R format.}
\usage{
dm_Rdate_Eti(Rdate, Y, num_knots_Eti, basis_Eti = "ncs")
}
\arguments{
\item{Rdate}{a vector of dates of R format}

\item{Y}{binary case/control status; 1 for case; 0 for controls}

\item{num_knots_Eti}{number of knots for etiology regression}

\item{basis_Eti}{the type of basis functions to use for etiology regression. It can be "ncs" (natural
cubic splines) or "tprs" (thin-plate regression splines). Default is "ncs". "tprs"
will be implemented later.}
}
\value{
Design matrix for etiology regression:
\itemize{
\item \code{Z_Eti} transformed design matrix for etiology regression
}
}
\description{
\code{dm_Rdate_Eti} creates design matrices for etiology regressions.
}
\details{
It is used in \code{model_options$likeihood$Eti_formula}. For example, one can specify
it as: \cr
\cr
\code{~ AGECAT+HIV+dm_Rdate_Eti(ENRLDATE,Y,5)} \cr
\cr
to call an etiology regression with intercept, main effects for 'AGECAT' and 'HIV', and
natural cubic spline bases for 'ENRLDATE' using 5 knots defined as 5 equal-probability-spaced
sample quantiles.
}
\seealso{
\code{\link[=nplcm]{nplcm()}}
}
