% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_reject_vpc_endpoint_connections}
\alias{ec2_reject_vpc_endpoint_connections}
\title{Reject Vpc Endpoint Connections}
\usage{
ec2_reject_vpc_endpoint_connections(
  ServiceId,
  VpcEndpointId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ServiceId}{String. The ID of the service.}

\item{VpcEndpointId}{List. The IDs of one or more VPC endpoints.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Rejects one or more VPC endpoint connection
requests to your VPC endpoint service.
}
\section{ServiceId}{

The ID of the
service.
}

\section{VpcEndpointId}{

The IDs of one or more VPC
endpoints.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

