% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_attribute}
\alias{ec2_modify_vpc_attribute}
\title{Modify Vpc Attribute}
\usage{
ec2_modify_vpc_attribute(
  VpcId,
  EnableDnsHostnames = NULL,
  EnableDnsSupport = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{EnableDnsHostnames}{Object.   Indicates whether the instances launched in the VPC get DNS hostnames.[optional]}

\item{EnableDnsSupport}{Object.   Indicates whether the DNS resolution is supported for the VPC.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified attribute of the specified
VPC.
}
\section{VpcId}{

The ID of the
VPC.
}

\section{EnableDnsHostnames}{


Indicates whether the instances launched in the VPC get DNS hostnames.
If enabled, instances in the VPC get DNS hostnames; otherwise, they do
not.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute. You can only
enable DNS hostnames if you\'ve enabled DNS support.
}

\section{EnableDnsSupport}{


Indicates whether the DNS resolution is supported for the VPC. If
enabled, queries to the Amazon provided DNS server at the
169.254.169.253 IP address, or the reserved IP address at the base of
the VPC network range \'plus two\' succeed. If disabled, the Amazon
provided DNS service in the VPC that resolves public DNS hostnames to IP
addresses is not enabled.

You cannot modify the DNS resolution and DNS hostnames attributes in the
same request. Use separate requests for each attribute.
}

