% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_instance_capacity_reservation_attributes}
\alias{ec2_modify_instance_capacity_reservation_attributes}
\title{Modify Instance Capacity Reservation Attributes}
\usage{
ec2_modify_instance_capacity_reservation_attributes(
  InstanceId,
  CapacityReservationSpecification,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{String. The ID of the instance to be modified.}

\item{CapacityReservationSpecification}{Object. Information about the Capacity Reservation targeting option.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the Capacity Reservation settings for a
stopped instance. Use this action to configure an instance to target a
specific Capacity Reservation, run in any \code{open} Capacity Reservation
with matching attributes, or run On-Demand Instance
capacity.
}
\section{InstanceId}{

The ID of the instance to be
modified.
}

\section{CapacityReservationSpecification}{

Information about the Capacity Reservation
targeting option.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

