% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_transit_gateway_route_table_associations}
\alias{ec2_get_transit_gateway_route_table_associations}
\title{Get Transit Gateway Route Table Associations}
\usage{
ec2_get_transit_gateway_route_table_associations(
  TransitGatewayRouteTableId,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayRouteTableId}{String. The ID of the transit gateway route table.}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Gets information about the
associations for the specified transit gateway route
table.
}
\section{TransitGatewayRouteTableId}{

The ID of the transit
gateway route table.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The resource type. Valid values are \code{vpc} \| \code{vpn}
\| \code{direct-connect-gateway} \| \code{peering} \| \code{connect}.
\item \code{transit-gateway-attachment-id} - The ID of the attachment.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

