% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_security_group_references}
\alias{ec2_describe_security_group_references}
\title{Describe Security Group References}
\usage{
ec2_describe_security_group_references(
  GroupId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupId}{List. The IDs of the security groups in your account.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
[VPC only] Describes the
VPCs on the other side of a VPC peering connection that are referencing
the security groups you\'ve specified in this
request.
}
\section{GroupId}{

The IDs of the security groups in your
account.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

