% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_deregister_transit_gateway_multicast_group_members}
\alias{ec2_deregister_transit_gateway_multicast_group_members}
\title{Deregister Transit Gateway Multicast Group Members}
\usage{
ec2_deregister_transit_gateway_multicast_group_members(
  TransitGatewayMulticastDomainId = NULL,
  GroupIpAddress = NULL,
  NetworkInterfaceIds = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{String. The ID of the transit gateway multicast domain.[optional]}

\item{GroupIpAddress}{String. The IP address assigned to the transit gateway multicast group.[optional]}

\item{NetworkInterfaceIds}{List. The IDs of the group members\' network interfaces.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deregisters the
specified members (network interfaces) from the transit gateway
multicast group.
}
\section{TransitGatewayMulticastDomainId}{

The ID of the transit gateway
multicast domain.
}

\section{GroupIpAddress}{

The IP address assigned to the
transit gateway multicast group.
}

\section{NetworkInterfaceIds}{

The IDs of the
group members\' network interfaces.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

