% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\alias{fit.AutokerasModel}
\title{Search for the Best Model and Hyperparameters}
\usage{
\method{fit}{AutokerasModel}(
  object,
  x = NULL,
  y = NULL,
  epochs = 1000,
  callbacks = NULL,
  validation_split = 0.2,
  validation_data = NULL,
  ...
)
}
\arguments{
\item{object}{: An AutokerasModel instance.}

\item{x}{: Training data x. Check corresponding AutokerasModel help to note
how it should be provided.}

\item{y}{: Training data y. Check corresponding AutokerasModel help to note
how it should be provided.}

\item{epochs}{: numeric. The number of epochs to train each model during the
search. If unspecified, by default we train for a maximum of `1000` epochs,
but we stop training if the validation loss stops improving for 10 epochs
(unless you specified an EarlyStopping callback as part of the `callbacks`
argument, in which case the EarlyStopping callback you specified will
determine early stopping).}

\item{callbacks}{: list of Keras callbacks to apply during training and
validation.}

\item{validation_split}{: numeric between 0 and 1. Defaults to `0.2`.
Fraction of the training data to be used as validation data. The model will
set apart this fraction of the training data, will not train on it, and
will evaluate the loss and any model metrics on this data at the end of
each epoch. The validation data is selected from the last samples in the
`x` and `y` data provided, before shuffling. This argument is not supported
when `x` is a dataset. The best model found would be fit on the entire
dataset including the validation data.}

\item{validation_data}{: Data on which to evaluate the loss and any model
metrics at the end of each epoch. The model will not be trained on this
data. `validation_data` will override `validation_split`. The type of the
validation data should be the same as the training data. The best model
found would be fit on the training dataset without the validation data.}

\item{...}{: Unused.}
}
\value{
A trained AutokerasModel.
}
\description{
It will search for the best model and hyperparameters based on the
performances on validation data.
}
\examples{
\dontrun{
library("keras")

# use the MNIST dataset as an example
mnist <- dataset_mnist()
c(x_train, y_train) \%<-\% mnist$train
c(x_test, y_test) \%<-\% mnist$test

library("autokeras")

# Initialize the image classifier
clf <- model_image_classifier(max_trials = 10) \%>\% # It tries 10 different models
  fit(x_train, y_train) # Feed the image classifier with training data

# If you want to use own valitadion data do:
clf <- model_image_classifier(max_trials = 10) \%>\%
  fit(
    x_train,
    y_train,
    validation_data = list(x_test, y_test)
  )

# Predict with the best model
(predicted_y <- clf \%>\% predict(x_test))

# Evaluate the best model with testing data
clf \%>\% evaluate(x_test, y_test)

# Get the best trained Keras model, to work with the keras R library
export_model(clf)
}

}
