% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_partition.R
\name{layout_partition}
\alias{layout_partition}
\alias{layout_concentric}
\alias{layout_tbl_graph_concentric}
\alias{layout_multilevel}
\alias{layout_tbl_graph_multilevel}
\alias{layout_lineage}
\alias{layout_tbl_graph_lineage}
\alias{layout_hierarchy}
\alias{layout_tbl_graph_hierarchy}
\alias{layout_alluvial}
\alias{layout_tbl_graph_alluvial}
\alias{layout_railway}
\alias{layout_tbl_graph_railway}
\alias{layout_ladder}
\alias{layout_tbl_graph_ladder}
\title{Layout algorithms based on bi- or other partitions}
\source{
Diego Diez, Andrew P. Hutchins and Diego Miranda-Saavedra. 2014.
"Systematic identification of transcriptional regulatory modules from
protein-protein interaction networks".
\emph{Nucleic Acids Research}, 42 (1) e6.
}
\usage{
layout_concentric(
  .data,
  membership,
  radius = NULL,
  order.by = NULL,
  circular = FALSE,
  times = 1000
)

layout_tbl_graph_concentric(
  .data,
  membership,
  radius = NULL,
  order.by = NULL,
  circular = FALSE,
  times = 1000
)

layout_multilevel(.data, level, circular = FALSE)

layout_tbl_graph_multilevel(.data, level, circular = FALSE)

layout_lineage(.data, rank, circular = FALSE)

layout_tbl_graph_lineage(.data, rank, circular = FALSE)

layout_hierarchy(.data, center = NULL, circular = FALSE, times = 1000)

layout_tbl_graph_hierarchy(
  .data,
  center = NULL,
  circular = FALSE,
  times = 1000
)

layout_alluvial(.data, circular = FALSE, times = 1000)

layout_tbl_graph_alluvial(.data, circular = FALSE, times = 1000)

layout_railway(.data, circular = FALSE, times = 1000)

layout_tbl_graph_railway(.data, circular = FALSE, times = 1000)

layout_ladder(.data, circular = FALSE, times = 1000)

layout_tbl_graph_ladder(.data, circular = FALSE, times = 1000)
}
\arguments{
\item{.data}{Some \code{{manynet}} compatible network data.}

\item{membership}{A node attribute or a vector to draw concentric circles
for "concentric" layout.}

\item{radius}{A vector of radii at which the concentric circles
should be located for "concentric" layout.
By default this is equal placement around an empty centre,
unless one (the core) is a single node,
in which case this node occupies the centre of the graph.}

\item{order.by}{An attribute label indicating the (decreasing) order
for the nodes around the circles for "concentric" layout.
By default ordering is given by a bipartite placement that reduces
the number of edge crossings.}

\item{circular}{Should the layout be transformed into a radial representation.
Only possible for some layouts. Defaults to FALSE.}

\item{times}{Maximum number of iterations, where appropriate}

\item{level}{A node attribute or a vector to hierarchically order levels for
"multilevel" layout.}

\item{rank}{A numerical node attribute to place nodes in Y axis
according to values for "lineage" layout.}

\item{center}{Further split "hierarchical" layouts by
declaring the "center" argument as the "events", "actors",
or by declaring a node name in hierarchy layout.
Defaults to NULL.}
}
\description{
These algorithms layout networks based on two or more partitions,
and are recommended for use with \code{graphr()} or \code{{ggraph}}.
Note that these layout algorithms use \code{{Rgraphviz}},
a package that is only available on Bioconductor.
It will first need to be downloaded using \code{BiocManager::install("Rgraphviz")}.
If it has not already been installed, there is a prompt the first time
these functions are used though.

The "hierarchy" layout layers the first node set along the bottom,
and the second node set along the top,
sequenced and spaced as necessary to minimise edge overlap.
The "alluvial" layout is similar to "hierarchy",
but places successive layers horizontally rather than vertically.
The "railway" layout is similar to "hierarchy",
but nodes are aligned across the layers.
The "ladder" layout is similar to "railway",
but places successive layers horizontally rather than vertically.
The "concentric" layout places a "hierarchy" layout
around a circle, with successive layers appearing as concentric circles.
The "multilevel" layout places successive layers as multiple levels.
The "lineage" layout ranks nodes in Y axis according to values.
}
\examples{
#graphr(ison_southern_women, layout = "concentric", membership = "type",
#           node_color = "type", node_size = 3)
#graphr(ison_lotr, layout = "multilevel",
#           node_color = "Race", level = "Race", node_size = 3)
# ison_adolescents \%>\%
#   mutate(year = rep(c(1985, 1990, 1995, 2000), times = 2),
#          cut = node_is_cutpoint(ison_adolescents)) \%>\%
#   graphr(layout = "lineage", rank = "year", node_color = "cut",
#              node_size = migraph::node_degree(ison_adolescents)*10)
#graphr(ison_southern_women, layout = "hierarchy", center = "events",
#           node_color = "type", node_size = 3)
#graphr(ison_southern_women, layout = "alluvial")
}
\seealso{
Other mapping: 
\code{\link{layout_configuration}()},
\code{\link{map_graphr}},
\code{\link{map_graphs}},
\code{\link{map_grapht}}
}
\concept{mapping}
