/*
 * Decompiled with CFR 0.152.
 */
public class PRM_CARgen
extends Classification {
    protected ExamplesStruct[] positiveExamples = null;
    protected ExamplesStruct[] negativeExamples = null;
    protected ExamplesStruct[] positiveExamples2 = null;
    protected ExamplesStruct[] negativeExamples2 = null;
    protected double[][] pn_array = null;
    protected double[][] pn_array2 = null;
    protected final double TOTAL_WEIGHT_FACTOR = 0.05;
    protected final double DECAY_FACROR = 0.3333333333333333;

    public PRM_CARgen(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public double startClassification() {
        System.out.println("START PRM CLASSIFICATION\n------------------------");
        this.currentRlist.startRulelist = null;
        this.currentRlist.setDataArray(this.dataArray);
        this.currentRlist.setNumClasses(this.numClasses);
        if (this.classifiers == null) {
            System.out.println("ERROR: no classifiers array! To create a classifiers array use createClassifiersArray(), contained in ClassAprioriTserial class, called from the application class.");
            System.exit(1);
        }
        this.startPRM();
        this.processRules();
        return this.twoDecPlaces(this.testClassification());
    }

    private void startPRM() {
        int n;
        this.attributes = new double[this.numOneItemSets - this.numClasses + 1][2];
        for (n = 0; n < this.attributes.length; ++n) {
            this.attributes[n][0] = 0.0;
            this.attributes[n][1] = 0.0;
        }
        block1: for (n = 0; n < this.classifiers.length; ++n) {
            this.generatePosAndNegExamples(this.classifiers[n]);
            this.generatePNarray();
            double d = 0.05 * this.getTotalWeighting(this.positiveExamples);
            short[] sArray = new short[]{this.classifiers[n]};
            while (this.getTotalWeighting(this.positiveExamples) > d) {
                this.positiveExamples2 = this.copyExamplesArray(this.positiveExamples);
                this.negativeExamples2 = this.copyExamplesArray(this.negativeExamples);
                this.pn_array2 = this.copyDouble2Darray(this.pn_array);
                this.attributes2 = this.copyDouble2Darray(this.attributes);
                if (this.noValidGainsinPNarray()) continue block1;
                this.prmGeneration(null, sArray);
            }
        }
    }

    private void prmGeneration(short[] sArray, short[] sArray2) {
        double d = this.getWeightOfExamples(this.positiveExamples2);
        double d2 = this.getWeightOfExamples(this.negativeExamples2);
        this.calculateGains(d, d2);
        int n = this.getBestGain();
        double d3 = this.attributes2[n][1];
        if (d3 <= 0.7) {
            this.foundRule(sArray, sArray2);
            return;
        }
        sArray = this.reallocInsert(sArray, (short)n);
        this.attributes2[n][0] = 1.0;
        this.positiveExamples2 = this.removeExDoNotSatRule(0, sArray, this.positiveExamples2);
        this.negativeExamples2 = this.removeExDoNotSatRule(1, sArray, this.negativeExamples2);
        if (this.negativeExamples2 == null) {
            this.foundRule(sArray, sArray2);
            return;
        }
        this.prmGeneration(sArray, sArray2);
    }

    protected void foundRule(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return;
        }
        double d = this.currentRlist.getLaplaceAccuracy(sArray, sArray2[0]);
        this.currentRlist.insertRuleintoRulelist(sArray, sArray2, d);
        this.revisePosExDoSatRule(sArray, this.positiveExamples);
    }

    protected void calculateGains(double d, double d2) {
        for (int i = 1; i < this.attributes2.length; ++i) {
            if ((int)this.attributes2[i][0] != 0) continue;
            double d3 = this.pn_array2[i][0];
            double d4 = this.pn_array2[i][1];
            this.attributes2[i][1] = this.calculateGain(d3, d4, d, d2);
        }
    }

    protected double calculateGain(double d, double d2, double d3, double d4) {
        if ((int)d == 0) {
            return 0.0;
        }
        double d5 = Math.log(d3 / (d3 + d4));
        double d6 = Math.log(d / (d + d2));
        return d * (d6 - d5);
    }

    protected void generatePosAndNegExamples(short s) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.dataArray.length; ++n2) {
            n = this.dataArray[n2].length - 1;
            if (this.dataArray[n2][n] == s) {
                ++n3;
                continue;
            }
            ++n4;
        }
        this.positiveExamples = new ExamplesStruct[n3];
        this.negativeExamples = new ExamplesStruct[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.dataArray.length; ++n2) {
            n = this.dataArray[n2].length - 1;
            if (this.dataArray[n2][n] == s) {
                this.positiveExamples[n3] = new ExamplesStruct(this.dataArray[n2]);
                ++n3;
                continue;
            }
            this.negativeExamples[n4] = new ExamplesStruct(this.dataArray[n2]);
            ++n4;
        }
    }

    protected int getWeightOfExamples(ExamplesStruct[] examplesStructArray) {
        if (examplesStructArray == null) {
            return 0;
        }
        return examplesStructArray.length;
    }

    protected ExamplesStruct[] removeExDoNotSatRule(int n, short[] sArray, ExamplesStruct[] examplesStructArray) {
        if (examplesStructArray == null) {
            return null;
        }
        int n2 = this.getNumExDoSatRule(sArray, examplesStructArray);
        if (n2 == 0) {
            for (int i = 1; i < this.pn_array2.length; ++i) {
                this.pn_array2[i][n] = 0.0;
            }
            return null;
        }
        ExamplesStruct[] examplesStructArray2 = new ExamplesStruct[n2];
        int n3 = 0;
        for (int i = 0; i < examplesStructArray.length; ++i) {
            if (this.isSubset(sArray, examplesStructArray[i].itemSet)) {
                examplesStructArray2[n3] = new ExamplesStruct(examplesStructArray[i].itemSet, examplesStructArray[i].weighting);
                ++n3;
                continue;
            }
            int n4 = examplesStructArray[i].itemSet.length - 1;
            for (int j = 0; j < n4; ++j) {
                short s = examplesStructArray[i].itemSet[j];
                this.pn_array2[s][n] = this.pn_array2[s][n] - examplesStructArray[i].weighting;
            }
        }
        return examplesStructArray2;
    }

    protected void revisePosExDoSatRule(short[] sArray, ExamplesStruct[] examplesStructArray) {
        for (int i = 0; i < examplesStructArray.length; ++i) {
            if (!this.isSubset(sArray, examplesStructArray[i].itemSet)) continue;
            double d = examplesStructArray[i].weighting;
            examplesStructArray[i].weighting = d * 0.3333333333333333;
            double d2 = d - examplesStructArray[i].weighting;
            int n = examplesStructArray[i].itemSet.length - 1;
            for (int j = 0; j < n; ++j) {
                short s = examplesStructArray[i].itemSet[j];
                this.pn_array[s][0] = this.pn_array[s][0] - d2;
            }
        }
    }

    private int getNumExDoSatRule(short[] sArray, ExamplesStruct[] examplesStructArray) {
        int n = 0;
        for (int i = 0; i < examplesStructArray.length; ++i) {
            if (!this.isSubset(sArray, examplesStructArray[i].itemSet)) continue;
            ++n;
        }
        return n;
    }

    protected ExamplesStruct[] copyExamplesArray(ExamplesStruct[] examplesStructArray) {
        if (examplesStructArray == null) {
            return null;
        }
        ExamplesStruct[] examplesStructArray2 = new ExamplesStruct[examplesStructArray.length];
        for (int i = 0; i < examplesStructArray.length; ++i) {
            examplesStructArray2[i] = new ExamplesStruct(examplesStructArray[i].itemSet, examplesStructArray[i].weighting);
        }
        return examplesStructArray2;
    }

    protected void generatePNarray() {
        int n;
        this.pn_array = new double[this.numOneItemSets - this.numClasses + 1][2];
        for (n = 0; n < this.positiveExamples.length; ++n) {
            this.generatePNarrayP(this.positiveExamples[n].itemSet, this.positiveExamples[n].weighting);
        }
        for (n = 0; n < this.negativeExamples.length; ++n) {
            this.generatePNarrayN(this.negativeExamples[n].itemSet, this.negativeExamples[n].weighting);
        }
    }

    protected void generatePNarrayP(short[] sArray, double d) {
        int n = sArray.length - 1;
        for (int i = 0; i < n; ++i) {
            this.pn_array[sArray[i]][0] = this.pn_array[sArray[i]][0] + d;
        }
    }

    protected void generatePNarrayN(short[] sArray, double d) {
        int n = sArray.length - 1;
        for (int i = 0; i < n; ++i) {
            this.pn_array[sArray[i]][1] = this.pn_array[sArray[i]][1] + d;
        }
    }

    protected boolean noValidGainsinPNarray() {
        boolean bl = true;
        double d = this.getWeightOfExamples(this.positiveExamples2);
        double d2 = this.getWeightOfExamples(this.negativeExamples2);
        for (int i = 1; i < this.pn_array2.length; ++i) {
            double d3 = this.pn_array2[i][0];
            double d4 = this.pn_array2[i][1];
            double d5 = this.calculateGain(d3, d4, d, d2);
            if (!(d5 > 0.7)) continue;
            bl = false;
        }
        return bl;
    }

    protected double getTotalWeighting(ExamplesStruct[] examplesStructArray) {
        double d = 0.0;
        for (int i = 0; i < examplesStructArray.length; ++i) {
            d += examplesStructArray[i].weighting;
        }
        return d;
    }

    @Override
    protected void outputSettings() {
        System.out.println("SETTINGS\n----------");
        System.out.println("File name           = " + this.fileName);
        System.out.println("Num. classes        = " + this.numClasses);
        System.out.println("K value             = 5");
        System.out.println("Min. best gain      = 0.7");
        System.out.println("Total Weight Factor = 0.05");
        System.out.println("Decay factor        = 0.3333333333333333");
        System.out.println();
    }

    protected class ExamplesStruct {
        short[] itemSet;
        double weighting = 1.0;

        protected ExamplesStruct(short[] sArray) {
            this.itemSet = PRM_CARgen.this.copyItemSet(sArray);
        }

        protected ExamplesStruct(short[] sArray, double d) {
            this.itemSet = PRM_CARgen.this.copyItemSet(sArray);
            this.weighting = d;
        }
    }
}

