% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.R
\docType{methods}
\name{c}
\alias{c}
\alias{c,itemMatrix-method}
\alias{c,transactions-method}
\alias{c,tidLists-method}
\alias{c,rules-method}
\alias{c,itemsets-method}
\title{Combining Association and Transaction Objects}
\usage{
\S4method{c}{itemMatrix}(x, ..., recursive = FALSE)

\S4method{c}{transactions}(x, ..., recursive = FALSE)

\S4method{c}{tidLists}(x, ..., recursive = FALSE)

\S4method{c}{rules}(x, ..., recursive = FALSE)

\S4method{c}{itemsets}(x, ..., recursive = FALSE)
}
\arguments{
\item{x}{first object.}

\item{...}{further objects of the same class as \code{x} to be combined.}

\item{recursive}{a logical. If \code{recursive = TRUE}, the function
recursively descends through lists combining all their elements into a
vector.}
}
\value{
An object of the same class as \code{x}.
}
\description{
Provides the methods to combine several \link{associations} or \link{transactions} objects
into a single object.
}
\details{
Combining arules objects is done by combining the rows
of \link{itemMatrix} objects
representing the associations or transactions.

Note that \code{c()} can result in duplicates.
Use \code{\link[=union]{union()}} rather than \code{c()} to combine several mined
\link{itemsets} or \link{rules} into a single
set without duplicates.
}
\examples{
data("Adult")

## combine transactions
a1 <- Adult[1:10]
a2 <- Adult[101:110]

aComb <- c(a1, a2)
summary(aComb)

## combine rules (can contain the same rule multiple times)
r1 <- apriori(Adult[1:1000])
r2 <- apriori(Adult[1001:2000])
rComb <- c(r1, r2)
rComb

## union of rules (a set with only unique rules: same as unique(rComb))
rUnion <- union(r1, r2)
rUnion
}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
