% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SunBai.R
\docType{data}
\name{SunBai}
\alias{SunBai}
\alias{sunbai}
\title{The SunBai Weighted Transactions Data Set}
\format{
Object of class \link{transactions} with 6 transactions and 8 items. Weights are stored as transaction information.
}
\source{
K. Sun and F. Bai (2008). Mining Weighted Association Rules without
Preassigned Weights. \emph{IEEE Transactions on Knowledge and Data
Engineering}, 4 (30), 489--495.
}
\description{
A small example database for weighted association rule mining provided as an
object of class \link{transactions}.
}
\details{
The data set contains the example database described in the paper by K. Sun
and F.Bai for illustration of the concepts of weighted association rule
mining. \code{weight} stored as transaction information denotes the
transaction weights obtained using the HITS algorithm.
}
\examples{
data(SunBai)
summary(SunBai)
inspect(SunBai)

transactionInfo(SunBai)
}
\seealso{
Other weighted association mining functions: 
\code{\link{hits}()},
\code{\link{weclat}()}
}
\concept{weighted association mining functions}
\keyword{datasets}
