% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\docType{data}
\name{Permutations}
\alias{Permutations}
\alias{ipermutations}
\title{Permutations iterator}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Permutations

ipermutations(n, k = n, x = NULL, freq = NULL, replace = FALSE)
}
\arguments{
\item{n}{an integer, would be determined implicitly from \code{x} or \code{f} if missing}

\item{k}{an integer}

\item{x}{an optional vector indicating item labels}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}
}
\description{
This function returns a \href{Permutations-class.html}{Permutations} iterator which
allows users to fetch the next permutation(s) via the \code{getnext()} method. All remaing
permutations of the iterator can be fetched via the \code{collect()} method.
}
\details{
The \code{Permutations} class can be initialized by using the convenient wrapper \code{ipermutations} or
\preformatted{
Permutations$new(n, k, x = NULL, freq = NULL, replace = FALSE)
}

\preformatted{
getnext(d = 1L, type = NULL, drop = d == 1L && is.null(type))
collect(type = "r")
reset()
}
\describe{
\item{d}{number of fetched arrangements}

\item{type}{if "r", "c" or "l" is specified, the returned value would be a
 "row-major" matrix, a "column-major" matrix or a list respectively}

\item{drop}{vectorize a matrix or unlist a list}
}
}
\examples{
iperm <- ipermutations(5, 2)
iperm$getnext()
iperm$getnext(2)
iperm$getnext(type = "c", drop = FALSE)
# collect remaining permutations
iperm$collect()

library(foreach)
foreach(x = ipermutations(5, 2), .combine=c) \%do\% {
  sum(x)
}
}
\seealso{
\link{permutations} for generating all permutations and \link{npermutations} to calculate number of permutations
}
\keyword{datasets}
