CDF       
      	DATE_TIME         	STRING256         STRING64   @   STRING32       STRING8       STRING4       STRING2       N_PROF        N_PARAM       N_LEVELS  $   N_CALIB          	   title         Argo float vertical profile    institution       AOML   source        
Argo float     history       e2020-04-18T05:52:16Z creation (software version 1.7 (version 18.02.2019 for ARGO_simplified_profile))      
references        (http://www.argodatamgt.org/Documentation   user_manual_version       1.0    Conventions       Argo-3.1 CF-1.6    featureType       trajectoryProfile      software_version      41.7 (version 18.02.2019 for ARGO_simplified_profile)      O   	DATA_TYPE                  	long_name         	Data type      conventions       Argo reference table 1     
_FillValue                     Ft   FORMAT_VERSION                 	long_name         File format version    
_FillValue                    F   HANDBOOK_VERSION               	long_name         Data handbook version      
_FillValue                    F   REFERENCE_DATE_TIME                 	long_name         !Date of reference for Julian days      conventions       YYYYMMDDHHMISS     
_FillValue                    F   
DATE_CREATION                   	long_name         Date of file creation      conventions       YYYYMMDDHHMISS     
_FillValue                    F   DATE_UPDATE                 	long_name         Date of update of this file    conventions       YYYYMMDDHHMISS     
_FillValue                    F   PLATFORM_NUMBER                   	long_name         Float unique identifier    conventions       WMO float identifier : A9IIIII     
_FillValue                    F   PROJECT_NAME                  	long_name         Name of the project    
_FillValue                  @  F   PI_NAME                   	long_name         "Name of the principal investigator     
_FillValue                  @  G   STATION_PARAMETERS                       	long_name         ,List of available parameters for the station   conventions       Argo reference table 3     
_FillValue                   GT   CYCLE_NUMBER               	long_name         Float cycle number     conventions       =0...N, 0 : launch cycle (if exists), 1 : first complete cycle      
_FillValue                 I   	DIRECTION                  	long_name         !Direction of the station profiles      conventions       -A: ascending profiles, D: descending profiles      
_FillValue                    I   DATA_CENTRE                   	long_name         .Data centre in charge of float data processing     conventions       Argo reference table 4     
_FillValue                    I   PARAMETER_DATA_MODE                   	long_name         Delayed mode or real time data     conventions       >R : real time; D : delayed mode; A : real time with adjustment     
_FillValue                    I    
PLATFORM_TYPE                     	long_name         
Type of float      conventions       Argo reference table 23    
_FillValue                     I(   FLOAT_SERIAL_NO                   	long_name         Serial number of the float     
_FillValue                     IH   FIRMWARE_VERSION                  	long_name         Instrument firmware version    
_FillValue                     Ih   
WMO_INST_TYPE                     	long_name         Coded instrument type      conventions       Argo reference table 8     
_FillValue                    I   JULD               	long_name         ?Julian day (UTC) of the station relative to REFERENCE_DATE_TIME    
standard_name         time   units         "days since 1950-01-01 00:00:00 UTC     conventions       8Relative julian days with decimal part (as parts of day)   
_FillValue        A.~       axis      T      
resolution        >Ey0:        I   JULD_QC                	long_name         Quality on date and time   conventions       Argo reference table 2     
_FillValue                    I   
JULD_LOCATION                  	long_name         @Julian day (UTC) of the location relative to REFERENCE_DATE_TIME   units         "days since 1950-01-01 00:00:00 UTC     conventions       8Relative julian days with decimal part (as parts of day)   
_FillValue        A.~       
resolution        >Ey0:        I   LATITUDE               	long_name         &Latitude of the station, best estimate     
standard_name         latitude   units         degree_north   
_FillValue        @i       	valid_min         V        	valid_max         @V        axis      Y           I   	LONGITUDE                  	long_name         'Longitude of the station, best estimate    
standard_name         	longitude      units         degree_east    
_FillValue        @i       	valid_min         f        	valid_max         @f        axis      X           I   POSITION_QC                	long_name         ,Quality on position (latitude and longitude)   conventions       Argo reference table 2     
_FillValue                    I   POSITIONING_SYSTEM                    	long_name         Positioning system     
_FillValue                    I   CONFIG_MISSION_NUMBER                  	long_name         :Unique number denoting the missions performed by the float     conventions       !1...N, 1 : first complete mission      
_FillValue                 I   	PARAMETER            
               	long_name         /List of parameters with calibration information    conventions       Argo reference table 3     
_FillValue                   I   SCIENTIFIC_CALIB_EQUATION            
               	long_name         'Calibration equation for this parameter    
_FillValue                    K   SCIENTIFIC_CALIB_COEFFICIENT         
               	long_name         *Calibration coefficients for this equation     
_FillValue                    R   SCIENTIFIC_CALIB_COMMENT         
               	long_name         .Comment applying to this parameter calibration     
_FillValue                    Y   SCIENTIFIC_CALIB_DATE            
                	long_name         Date of calibration    conventions       YYYYMMDDHHMISS     
_FillValue                  d  `   PROFILE_PRES_QC                	long_name         #Global quality flag of PRES profile    conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_TEMP_QC                	long_name         #Global quality flag of TEMP profile    conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_PSAL_QC                	long_name         #Global quality flag of PSAL profile    conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_DOXY_QC                	long_name         #Global quality flag of DOXY profile    conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_CHLA_QC                	long_name         #Global quality flag of CHLA profile    conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_BBP700_QC                  	long_name         %Global quality flag of BBP700 profile      conventions       Argo reference table 2a    
_FillValue                    `   PROFILE_NITRATE_QC                 	long_name         &Global quality flag of NITRATE profile     conventions       Argo reference table 2a    
_FillValue                    `   PRES         	      
   	long_name         )Sea water pressure, equals 0 at sea-level      
standard_name         sea_water_pressure     
_FillValue        GO   units         decibar    	valid_min                	valid_max         F;    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =   axis      Z          a    PRES_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $  i   
PRES_ADJUSTED            	      
   	long_name         )Sea water pressure, equals 0 at sea-level      
standard_name         sea_water_pressure     
_FillValue        GO   units         decibar    	valid_min                	valid_max         F;    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =   axis      Z          k   PRES_ADJUSTED_QC         	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $  tD   PRES_ADJUSTED_ERROR          	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         decibar    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =       vh   TEMP         	      	   	long_name         $Sea temperature in-situ ITS-90 scale   
standard_name         sea_water_temperature      
_FillValue        GO   units         degree_Celsius     	valid_min               	valid_max         B      C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       ~   TEMP_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $     
TEMP_dPRES           	         	long_name         6TEMP pressure displacement from original sampled value     
_FillValue        GO   units         decibar           
TEMP_ADJUSTED            	      	   	long_name         $Sea temperature in-situ ITS-90 scale   
standard_name         sea_water_temperature      
_FillValue        GO   units         degree_Celsius     	valid_min               	valid_max         B      C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       <   TEMP_ADJUSTED_QC         	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $     TEMP_ADJUSTED_ERROR          	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         degree_Celsius     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o          PSAL         	      	   	long_name         Practical salinity     
standard_name         sea_water_salinity     
_FillValue        GO   units         psu    	valid_min         @      	valid_max         B$     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o          PSAL_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $     
PSAL_dPRES           	         	long_name         6PSAL pressure displacement from original sampled value     
_FillValue        GO   units         decibar        4   
PSAL_ADJUSTED            	      	   	long_name         Practical salinity     
standard_name         sea_water_salinity     
_FillValue        GO   units         psu    	valid_min         @      	valid_max         B$     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o          PSAL_ADJUSTED_QC         	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $  T   PSAL_ADJUSTED_ERROR          	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         psu    C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       x   DOXY         	      	   	long_name         Dissolved oxygen   
standard_name         *moles_of_oxygen_per_unit_mass_in_sea_water     
_FillValue        GO   units         micromole/kg   	valid_min              	valid_max         D     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o          DOXY_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $  Ԙ   
DOXY_dPRES           	         	long_name         6DOXY pressure displacement from original sampled value     
_FillValue        GO   units         decibar        ּ   
DOXY_ADJUSTED            	      	   	long_name         Dissolved oxygen   
standard_name         *moles_of_oxygen_per_unit_mass_in_sea_water     
_FillValue        GO   units         micromole/kg   	valid_min              	valid_max         D     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       L   DOXY_ADJUSTED_QC         	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $     DOXY_ADJUSTED_ERROR          	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         micromole/kg   C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o           CHLA         	         	long_name         
Chlorophyll-A      
standard_name         0mass_concentration_of_chlorophyll_a_in_sea_water   
_FillValue        GO   units         mg/m3      C_format      %.3f   FORTRAN_format        F.3    
resolution        <          CHLA_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $      
CHLA_dPRES           	         	long_name         6CHLA pressure displacement from original sampled value     
_FillValue        GO   units         decibar        D   
CHLA_ADJUSTED            	         	long_name         
Chlorophyll-A      
standard_name         0mass_concentration_of_chlorophyll_a_in_sea_water   
_FillValue        GO   units         mg/m3      C_format      %.3f   FORTRAN_format        F.3    
resolution        <         CHLA_ADJUSTED_QC         	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $ d   CHLA_ADJUSTED_ERROR          	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         mg/m3      C_format      %.3f   FORTRAN_format        F.3    
resolution        <         BBP700           	         	long_name         )Particle backscattering at 700 nanometers      
_FillValue        GO   units         m-1    C_format      %.3f   FORTRAN_format        F.3    
resolution        :o         	BBP700_QC            	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $ !   BBP700_dPRES         	         	long_name         8BBP700 pressure displacement from original sampled value   
_FillValue        GO   units         decibar       #   BBP700_ADJUSTED          	         	long_name         )Particle backscattering at 700 nanometers      
_FillValue        GO   units         m-1    C_format      %.3f   FORTRAN_format        F.3    
resolution        :o      ,\   BBP700_ADJUSTED_QC           	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $ 4   BBP700_ADJUSTED_ERROR            	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         m-1    C_format      %.3f   FORTRAN_format        F.3    
resolution        :o      7   NITRATE          	         	long_name         Nitrate    
standard_name         +moles_of_nitrate_per_unit_mass_in_sea_water    
_FillValue        GO   units         micromole/kg   C_format      %.2f   FORTRAN_format        F.2    
resolution        <#
      ?   
NITRATE_QC           	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $ H0   
NITRATE_dPRES            	         	long_name         9NITRATE pressure displacement from original sampled value      
_FillValue        GO   units         decibar       JT   NITRATE_ADJUSTED         	         	long_name         Nitrate    
standard_name         +moles_of_nitrate_per_unit_mass_in_sea_water    
_FillValue        GO   units         micromole/kg   C_format      %.2f   FORTRAN_format        F.2    
resolution        <#
      R   NITRATE_ADJUSTED_QC          	         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 $ [t   NITRATE_ADJUSTED_ERROR           	         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         micromole/kg   C_format      %.2f   FORTRAN_format        F.2    
resolution        <#
      ]Argo synthetic profile          1.0 1.2 19500101000000  20200418055216  20200418055216  5903586 US ARGO PROJECT                                                 STEPHEN RISER , KENNETH JOHNSON                                 PRES                                                            TEMP                                                            PSAL                                                            DOXY                                                            CHLA                                                            BBP700                                                          NITRATE                                                            A   AO  DDDDARR APEX                            5063                            121509                          846 @(1   @@4}-V@Pd/1   GPS        PRES                                                            TEMP                                                            PSAL                                                            DOXY                                                            CHLA                                                            BBP700                                                          NITRATE                                                         PRES_ADJUSTED = PRES - dP                                                                                                                                                                                                                                       none                                                                                                                                                                                                                                                            PSAL_ADJUSTED = sw_salt( sw_cndr(PSAL,TEMP,PRES), TEMP, PRES_ADJUSTED )                                                                                                                                                                                         DOXY_ADJUSTED=DOXY*G                                                                                                                                                                                                                                            CHLA_ADJUSTED=CHLA/A, NPQ corrected (Xing et al., 2012), spike profile added back in                                                                                                                                                                            not applicable                                                                                                                                                                                                                                                  not applicable                                                                                                                                                                                                                                                  dP =-0.03 dbar.                                                                                                                                                                                                                                                 none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            G=1.1600                                                                                                                                                                                                                                                        A=2                                                                                                                                                                                                                                                             not applicable                                                                                                                                                                                                                                                  not applicable                                                                                                                                                                                                                                                  Pressures adjusted by using pressure offset at the sea surface. The quoted error is manufacturer specified accuracy in dbar.                                                                                                                                    The quoted error is manufacturer specified accuracy with respect to ITS-90 at time of laboratory calibration.                                                                                                                                                   No significant salinity drift detected. Salinity adjusted for effects of pressure adjustment. The quoted error is max[0.01, 1xOW uncertainty] in PSS-78.                                                                                                        Polynomial calibration coeficients were used. G determined by surface measurement comparison to World Ocean Atlas 2009.See Takeshita et al.2013,doi:10.1002/jgrc.20399                                                                                          A is best estimate from Roesler et al., 2017, doi: 10.1002/lom3.10185                                                                                                                                                                                           not applicable                                                                                                                                                                                                                                                  not applicable                                                                                                                                                                                                                                                  20170331144048201703311440482017033114404820200416055752202004160557522020041605575220200416055752  A   A   A   F   F   F       @ff@  @ffA   A   A6ffA@  A`  A  AA  A  A  A  A  A  AA  A  A  B   B  B  B  B  B   B&B(  B0  B8  B:  B@  BH  BM33BP  BX  B`  Bb  Bh  Bp  Bu33Bx  B  B  B  B  B  B33B  BffB  BB  B  BB  B  B  B  B  B  B  B  B  B  BB  B  B33B  B  B  B  B  BߙB  B  B  B  B  BffB  B  B  C   C  C  C  C  C  C
  C  C
C  C  C  C  C  CfC  C  C  C  C   C!LC"  C$  C&  C(  C*  C+C,  C.  C0  C2C4  C5fC6  C8  C:  C<  C>  C?3C@  CB  CD  CF  CH  CICJ  CL  CN  CP  CR  CSLCT  CV  CX  CZ  C\  C]ffC^  C`  Cb  Cd  Cf  Cg  Ch  Cj  Cl  Cn  Cp  Cq  Cr  Ct  Cv  Cx  Cz  C{C|  C~  C  C  C  CfC  C  C  C  C  CٚC  C  C  C  C  CC3C  C  C  C  CC  C  C  C  C  CYC  C  C  C  C  CC  C  C  C  C  C C  C  C  C  C  Cs3C  C  C  C  C  C C  C  C  C  C  C C  C  C  C  C  CC  C  C  C  C  C  C  C  C  C  CٚC  C  C  C  C  C  C  C  C  C  Cs3C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  CC  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  C  CC  C  C  C  C  D   D  D  D D  D D  D D  D D  D D  D D  D D  D D	  D	 D	fD
  D
 D  D D  D D
  D
 D  D D  D D  D D  D D  D D  D D  D D  D D  DFfD D  D D  D D  D D  DfD  D D  D D  D D  D D  D D   D  D!  D! D"  D" D"3D#  D# D$  D$ D%  D% D&  D& D'  D' D(  D( D)  D) D*  D*yD+  D+ D,  D, D-  D- D.  D. D/  D/YD/ D0  D0 D1  D1 D2  D2 D3  D3 D4  D4 D5  D5 D6  D6 D7  D7 D8  D8 D9  D9 D:  D: D;  D; D; D<  D< D=  D= D>  D> D?  D? D@  D@ DA  DA DB  DB DC  DC DD  DD DE  DE DF  DF DG  DG DH  DHlDH DI  DI DJ  DJ DK  DK DL  DL DM  DM DN  DN DO  DO DP  DP DQ  DQ DR  DR DS  DS DT  DT DT DU  DU DV  DV DW  DW DX  DX DY  DY DZ  DZ D[  D[ D\  D\ D]  D] D^  D^ D_  D_ D`  D` Da  Da@ Da Db  Db Dc  Dc Dd  Dd De  De Df  Df Dg  DgyDh  Dh Di  Di Dj  Dj Dk  Dk Dl  Dl Dm  Dm DmDn  Dn Do  Do Dp  Dp Dq  Dq Dr  Dr Ds  Ds Dt  DtyDy11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111@\)@@\)A zA zA6HA@zA`zA=qA
=A=qA=qA=qA=qA=qA=qA
=A=qA=qA=qB BBBBB B&B(B0B8B:B@BHBMQBPBXB`BbBhBpBuQBxB\B\B\B\B\BBB\BuB\B)B\B\B)B\B\B\B\B\B\B\B\B\B\B)B\B\BBB\B\B\B\B\BߨB\B\B\B\B\BuB\B\B\C CCCCCC
CC
HCCCCCCCCCCC C!T{C"C$C&C(C*C+!HC,C.C0C2!HC4C5C6C8C:C<C>C?C@CBCDCFCHCIHCJCLCNCPCRCST{CTCVCXCZC\C]nC^C`CbCdCfCgChCjClCnCpCqCrCtCvCxCzC{HC|C~CCCC=CCCCCCqCCCCCCqC
CCCCCCCCCCC]qCCCCCCCCCCCCCCCCCCw
CCCCCCCCCCCCCCCCCCqCCCCCCCCCCCqCCCCCCCCCCCw
CCCCCCCCCCCCCCCCCCCCCCCCCCФCCCCCCCCCCCCCCCCCCCCCCCCCCФCCCCCD D DDDDDDDDDDDDDDDDD	D	D	RD
D
DDDDD
D
DDDDDDDDDDDDDDDDDDHRDDDDDDDDDRDDDDDDDDDDD D D!D!D"D"D"D#D#D$D$D%D%D&D&D'D'D(D(D)D)D*D*{D+D+D,D,D-D-D.D.D/D/[D/D0D0D1D1D2D2D3D3D4D4D5D5D6D6D7D7D8D8D9D9D:D:D;D;D;D<D<D=D=D>D>D?D?D@D@DADADBDBDCDCDDDDDEDEDFDFDGDGDHDHnDHDIDIDJDJDKDKDLDLDMDMDNDNDODODPDPDQDQDRDRDSDSDTDTDTDUDUDVDVDWDWDXDXDYDYDZDZD[D[D\D\D]D]D^D^D_D_D`D`DaDaADaDbDbDcDcDdDdDeDeDfDfDgDg{DhDhDiDiDjDjDkDkDlDlDmDmDmDnDnDoDoDpDpDqDqDrDrDsDsDtDt{Dy11811811181181118118111811811181181118118111811811181181118118111811811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111111118111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ArAQA@A=qA+A"hAAoA1AA  AARAAAAAAAAAAAAAA[AAAAAAAAAAAAAAAAAA-AAyAGA;AA#ApASAA@A7LADA/AڠA/AAAlA(ApAKARAA+AAA/A#A`A-AA!AĜAbA~A9rA  A$AAAAAbNAAdZAffA#A`AAAAAA&AA7AEAHAAApA&AKAAAVAAAAA=qApAsAffAAAOAA@A&AAMA1'A;dARAAAIAPAjAA-AxAAoAABAAjA#A33A9XAAA7AAFAffALA33AAA;dA\A)AbAAAA  AAOAlAhA~yA~EA}&A}A~(A~uA~A~A~A~A}A|A|MAzAy{AxuAxJAw\)AvAvAuAuhAu
=AtAtZAtAAt~At  AshsArArvAqdZAqCApApAp(Ap  AomAo͟AoAoAn9An1'AmAm/AmTAm%Ak
AkAjAj;AjAjAAi^AiSAhAhAhQAgTAghAghsAfAfjAe
AdAd=qAcAcAc
=AbRAbVAaAa+A`ĜA`EA_A_A_SA_ \A^HA^A^{A]ƨA]A\zA[A[dZAZRAZJAYhAY`BAY+AX`AXAXbNAW#AWPAW\)AW?}AW&AVAVRAVnAV1'AU<AUAU`BATyATAT9XASASxAS`BAS+AR9ARAQAQƨAQAP/AP+APIAP1AOFAOAOAOAOOAOoAOAN,ANȴAN!ANrANEAN(AMAMALALQAKAKSAJ/AJbAIAIxAIGAHAHjAHAGhsAGAF~AF AEAEAE~AEXADyADĜADjADEACACAC`BACVABjAB AAFAA`BAA+A@A@!A@vA@A?A?A?
=A>A>nA>A=A=FA=PA=OA=A<yA<A<1A;mA;A;7LA:/A:\A:EA:(A:bA9wA9hA9\)A9"A8A8+A8QA8 A7A7A7A7A7A7+A6`A6RA6A6ffA61'A5A5A5XA5VA4A4+A4=qA3A3
A3-A3xA37LA2/A2A2~A2MA2A1ƨA1jA1CA1A0A0ĜA0uA0EA0{A/A/hA/SA/
=A.A.A.nA.bA-TA-A-A-`BA-A,9A,ffA, A+A+wA+A+pA+
=A*A*A*~A* A)A)FA)A)GA)oA(HA(uA(=qA'A'A'hsA'KA&A&9A&DA&VA&-A%A%A%kA%`BA%VA$A$DA$=qA$bA#-A#33A"A"A"^5A"5?A!
A!7A!`BA!;dA!
=A RA ZA 9XA
AhA33AyA!A|AIA1AAhA7LAAzAAAJA
AAFAA;dAAAzArAMA(A1A;A-AAtAQA/AA!ArAQAJAAApAXAA9A~AAA1A7AOA&AAAĜAuAAA;AA#A
AAPAtAAA=qAA-ASAoAAnA
711811811181181118118111811811181181118118111811811181181118118111811811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111111118111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111        >        ?                    ?                       ?                          >                       ?333                       ?333                       >            ?        =                       ?                       >                    >L                    >                    ?                      >                    fff                    ?333                    ?fff                    =                    >                    >                    ?333                    ?                    ?                      ?                      >                    ?333                    >                    ?333                    ?fff                    333                    ?fff                    ?                       fff                    ?                       ?                      ?L                                        >                                        fff                                                                                                    >                                                                                                    >                                                                                                    ?fff                                                                                                    ?fff                                                                                                    L                                                                                                    ?                                                                                                    ?                                                                                                      >                                                                                                    ?                                                                                                      ?                                                                                                      333                                                            ArAQA@A=qA+A"hAAoA1AA  AARAAAAAAAAAAAAAA[AAAAAAAAAAAAAAAAAA-AAyAGA;AA#ApASAA@A7LADA/AڠA/AAAlA(ApAKARAA+AAA/A#A`A-AA!AĜAbA~A9rA  A$AAAAAbNAAdZAffA#A`AAAAAA&AA7AEAHAAApA&AKAAAVAAAAA=qApAsAffAAAOAA@A&AAMA1'A;dARAAAIAPAjAA-AxAAoAABAAjA#A33A9XAAA7AAFAffALA33AAA;dA\A)AbAAAA  AAOAlAhA~yA~EA}&A}A~(A~uA~A~A~A~A}A|A|MAzAy{AxuAxJAw\)AvAvAuAuhAu
=AtAtZAtAAt~At  AshsArArvAqdZAqCApApAp(Ap  AomAo͟AoAoAn9An1'AmAm/AmTAm%Ak
AkAjAj;AjAjAAi^AiSAhAhAhQAgTAghAghsAfAfjAe
AdAd=qAcAcAc
=AbRAbVAaAa+A`ĜA`EA_A_A_SA_ \A^HA^A^{A]ƨA]A\zA[A[dZAZRAZJAYhAY`BAY+AX`AXAXbNAW#AWPAW\)AW?}AW&AVAVRAVnAV1'AU<AUAU`BATyATAT9XASASxAS`BAS+AR9ARAQAQƨAQAP/AP+APIAP1AOFAOAOAOAOOAOoAOAN,ANȴAN!ANrANEAN(AMAMALALQAKAKSAJ/AJbAIAIxAIGAHAHjAHAGhsAGAF~AF AEAEAE~AEXADyADĜADjADEACACAC`BACVABjAB AAFAA`BAA+A@A@!A@vA@A?A?A?
=A>A>nA>A=A=FA=PA=OA=A<yA<A<1A;mA;A;7LA:/A:\A:EA:(A:bA9wA9hA9\)A9"A8A8+A8QA8 A7A7A7A7A7A7+A6`A6RA6A6ffA61'A5A5A5XA5VA4A4+A4=qA3A3
A3-A3xA37LA2/A2A2~A2MA2A1ƨA1jA1CA1A0A0ĜA0uA0EA0{A/A/hA/SA/
=A.A.A.nA.bA-TA-A-A-`BA-A,9A,ffA, A+A+wA+A+pA+
=A*A*A*~A* A)A)FA)A)GA)oA(HA(uA(=qA'A'A'hsA'KA&A&9A&DA&VA&-A%A%A%kA%`BA%VA$A$DA$=qA$bA#-A#33A"A"A"^5A"5?A!
A!7A!`BA!;dA!
=A RA ZA 9XA
AhA33AyA!A|AIA1AAhA7LAAzAAAJA
AAFAA;dAAAzArAMA(A1A;A-AAtAQA/AA!ArAQAJAAApAXAA9A~AAA1A7AOA&AAAĜAuAAA;AA#A
AAPAtAAA=qAA-ASAoAAnA
711811811181181118118111811811181181118118111811811181181118118111811811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111111118111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;oB<jB<jB<jB<jB<jB<jB<jB<jB;dB;dB;dB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB<jB=qB=qB=qB=qB=qB=qB=qB=qB=qB=qB=qB=qB<B<jB<jB<jB<(B;dB:^B9B9XB7LBB.B7BB BB+B  BBB#BBZBZBBKBBBABBsBBŢB3BtBBB7BlBPB=B:^B.B%B#B'B$B!BBbB+BBBBBsBsBBBBBfB/BBBBB}B!BB}B-BBBBBBBXBBɺB)BBHByBBBBBBBBAB7LB-B(BBBBB!B%B/B2-BRB_;BZBTB;dB33B1'B33B6FB9XB6FB6FB2-B2-B5tB6FB;dBKBCB\)BX+BVBCB=qBAB>wBBBCBSBcTBsByBy6BxBlBffB_;BJBA.B9XB33B-B+B)B(B&B%B&B&B)B)B)B#B BBoB!B\BVBJBJBDB
B
=B1B+B+B%B	BDB%BBBBBBBBBmBBfBZBBBBB/BBBBƨBBBwBjBXBFB?B-BBBBBBBBBBBB{BbB7BB~B}B|B{BxBvBrBqBpBoBpBoBmBkBjBg8BffBcTB`BB]/BZBW
BSBVBTBNBIBGBEBCB?}B<jB:^B9XB5?B49B49B5?B33B1'B49B49B49B33B2-B0!B/B,B(B"BBBhBJBBB  BBBBBBBsB`BTBHB'B;B)B/BBB)BBBBBBɺBƨBŢBŢBÖBBBqBdBXB?B3B-BBBBBBBBBBBBBB{BuBoBoBbB\BVBPBDB=B1B+B+B%BBBBBB B~B~B|B{ByBxBvBuBtBrBqBpBoBnBmBkBjBiyBhsBffBe`BcBcTBbNBaHB`BB_;B]/B\)B[#BZBXBW
BVBTBSBQBPBOBNBMBKBIBGBFBEBDBDBCBAB@B?}B=qB<jB:^B9XB8RB7LB6FB5?B33B2-B0!B/B-B,B+B)B(B&B%B$B#B"B!B BBBBBBBB{BoBhB\BVB
PBJBDB	7B+B%BBB  B
B
B
B
B
B
B
B
B
B
B
B
B
B
B
B
yB
sB
fB
`B
ZB
TB
NB
HB
HB
BB
;B
5B
/B
ܬB
)B
B
B
B
B
B
B
B
B
B
B
B
B
B
ɺB
ƨB
ŢB
ŢB
ŢB
ŢB
ĜB
B
B
B
}B
}B
}B
B
}B
wB
jB
XB
9B
'B
B
B
B
B
B
B
{11811811181181118118111811811181181118118111811811181181118118111811811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111111118111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111        >        ?                    ?                       ?                          >                       ?333                       ?333                       >            ?        =                       ?                       >                    >L                    >                    ?                      >                    fff                    ?333                    ?fff                    =                    >                    >                    ?333                    ?                    ?                      ?                      >                    ?333                    >                    ?333                    ?fff                    333                    ?fff                    ?                       fff                    ?                       ?                      ?L                                        >                                        fff                                                                                                    >                                                                                                    >                                                                                                    ?fff                                                                                                    ?fff                                                                                                    L                                                                                                    ?                                                                                                    ?                                                                                                      >                                                                                                    ?                                                                                                      ?                                                                                                      333                                                            B<fB<kB<iB<iB<gB<hB<hB<gB;bB;bB;aB<eB<hB<iB<fB<kB<jB<iB<kB<jB<iB<jB<eB<fB<iB<iB<kB<kB=nB=pB=pB=pB=nB=nB=nB=pB=nB=nB=nB=pB<B<fB<iB<iB<'B;bB:]B9B9XB7JBB-B7BB B B%BBBB BBVBUBBHBBB?BBqBBşB/BqBBB5BlBPB=B:ZB.B%B#B'B$B!BB\B%BBBBzBpBuBBBB{BcB*BBBBBuBBBzB+BBBBBBBWBBɷB+BBGBvBBBBBBBBAB7IB-B(BBB{BB!B%B/B2-BRB_8BZBTB;bB32B1#B30B6DB9WB6EB6DB2(B2+B5tB6FB;aBKBCB\%BX'BV BCB=qBAB>uBBBCBSBcNBsByBy2BxBlBfcB_8BJBA+B9VB30B-
B+B)B(B&B%B&B&B)B)B)B#B BBoBBWBRBEBFB@B
B
<B.B&B)B$B	B>B#BBBBBBBB{BhBBeBUB@B>B,BBBBƢBBBtBcBTB?B:B+BBBBBBBBBBBBBxBLBBB~	B}B{BxBvBrBqBpBoBpBoBmBkBjBgIBfwBcfB`VB]EBZ,BWBTBVBUBNBIBGBEBCB?B<|B:oB9kB5OB4HB4JB5PB3CB16B4JB4JB4JB3BB2<B00B/(B,B)B"BBBxBVB+BB 
BBBBBBBBnBaBWB4BFB4B;BNB7B$BBBBBBƵBŲBŰBßBBB~BnBaBJBAB:B&BBB
BBBBBBBBBBBBzByBmBgB]B[BOBGB:B0B/B-B)BB"BBBBBB|B{ByBxBvBuBtBrBqBpBoBnBmBkBjBi~BhxBflBegBcBcXBbVBaPB`HB_EB]6B\2B['BZ&BXBWBVBUBTBQBPBOBNBMBKBIBGBFBEBDBDBCBAB@B?B=xB<lB:dB9`B8YB7PB6JB5CB37B21B0&B/"B-B,
B+B*B(B&B%B$B#B" B!B BBBBBBBBBsBoB_B_B
UBMBJB	<B-B*BBB B
B
B
B
B
B
B
B
B
B
B
B
B
B
B
B
yB
tB
jB
aB
^B
TB
NB
LB
LB
FB
AB
7B
3B
ܱB
/B
 B
B
B

B
 B
B
B
B
B
B
B
B
B
ɼB
ƬB
ŧB
ŦB
ťB
ťB
ĞB
B
B
B
B
B
~B
B
B
yB
mB
XB
9B
(B
B
B
B
B
B
B
}11811811181181118118111811811181181118118111811811181181118118111811811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111811111111118111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111111111111181111111111111111111111111811111111111111111111111118111111111111111<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
GOGOC'RGOGOC' XGOGOGOC%&GOGOC%GOGOGOC$jGOGOC#GOGOGOC#aGOGOC#!GOGOGOC"GOGOC"GOGOGOC"GOGOC!GOGOGOC lGOGOCYGOGOGOB$GOGOBtGOGOGOB{GOGOB GOGOGOAGOGOAEGOGOGOGOGOA[&pGOGOGOGOGO@VNGOGOGOGOGO?GOGOGOGOGO?JGOGOGOGOGO=bGOGOGOGOGO<l6GOGOGOGOGO<GOGOGOGOGO<kGOGOGOGOGO<d]GOGOGOGOGO<eGOGOGOGOGO<qGOGOGOGOGO<{GOGOGOGOGO<BGOGOGOGOGO<ǏGOGOGOGOGO<GOGOGOGOGO<ˆmGOGOGOGOGO<#GOGOGOGOGO<GOGOGOGOGO<GOGOGOGOGO<6GOGOGOGOGO<qGOGOGOGOGO<įGOGOGOGOGO<GOGOGOGOGO<GGOGOGOGOGO<
GOGOGOGOGO<GOGOGOGOGOGOGOGOGOGO<lGOGOGOGOGOGOGOGOGOGO<սAGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=0GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=fGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=3CGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=/>GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=b#ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=iigGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=h#GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=kGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=y&GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO>GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO>GOGOGOGOGOGOGOGOGOGOGOGOGOGO?-w  3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3          3          3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3              3GOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOCBGGOGOCAGOGOGOC@GOGOC?yGOGOGOC>GOGOC=GOGOGOC=GOGOC=;GOGOGOC<GOGOC<GGOGOGOC<lGOGOC;GOGOGOC:GOGOC7GOGOGOB?_GOGOB.GOGOGOB)'GOGOBGOGOGOB	oGOGOAGOGOGOGOGOA~6GOGOGOGOGO@yGOGOGOGOGO?5GOGOGOGOGO@GOGOGOGOGO=GOGOGOGOGO<+GOGOGOGOGO<ʄGOGOGOGOGO<ڑYGOGOGOGOGO<MGOGOGOGOGO<GOGOGOGOGO<GOGOGOGOGO<eGOGOGOGOGO<`GOGOGOGOGO<~GOGOGOGOGO=PYGOGOGOGOGO<GOGOGOGOGO<˦	GOGOGOGOGO<CGOGOGOGOGO<	WGOGOGOGOGO< GOGOGOGOGO<ΛGOGOGOGOGO<(@GOGOGOGOGO<sGOGOGOGOGO<gGOGOGOGOGO<gSGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGO<+`GOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=HGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=4vGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=OGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=K>GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=(GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=`GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=BGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ӫ@GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO>6CGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO>iGOGOGOGOGOGOGOGOGOGOGOGOGOGO?I9)  1  1   1  1   1  1   1  1   1  1   1  1   1  1   1  1   1  1   1  1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1     1          1          1                         1                         1                         1                         1                         1                         1                         1                         1                         1                         1                         1              1GOGO?pGOGO?GOGOGO?tWGOGO?{GOGOGO? GOGO?#GOGOGO?"GOGO?7GOGOGO?"GOGO?IPGOGOGO?GOGO?'GOGOGO?2GOGO?GOGOGO>GOGO>eGOGOGO>*pGOGO>6GOGOGO>GOGO>]GOGOGOGOGO>"sGOGOGOGOGO=f>GOGOGOGOGO<BGOGOGOGOGO<GOGOGOGOGO:MypGOGOGOGOGO9lGOGOGOGOGO9MGOGOGOGOGO9%GOGOGOGOGO9p2GOGOGOGOGO9tGOGOGOGOGO93[GOGOGOGOGO9]GOGOGOGOGO9WGGOGOGOGOGO9'GOGOGOGOGO9qGOGOGOGOGO9GOGOGOGOGO9UGOGOGOGOGO9GOGOGOGOGO9s?(GOGOGOGOGO9q1GOGOGOGOGO9:GOGOGOGOGO9GGOGOGOGOGO9mGOGOGOGOGO9X GOGOGOGOGO9ojGOGOGOGOGO9hcGOGOGOGOGOGOGOGOGOGO9GOGOGOGOGOGOGOGOGOGO9GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9](GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:'GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:-HGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:,GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:/![GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:wGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO:LsGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO;GOGOGOGOGOGOGOGOGOGOGOGOGOGO< lGOGO?rGOGO?c GOGOGO?KGOGO?N<GOGOGO?9XGOGO?RTGOGOGO?GOGO?܄GOGOGO?GOGO?˲GOGOGO?GOGO?JGOGOGO?GOGO?oGOGOGO>GOGO>_GOGOGO>$tTGOGO>_GOGOGO=ZGOGO=N<GOGOGOGOGO=o4GOGOGOGOGO=o4GOGOGOGOGO=o4GOGOGOGOGO=GOGOGOGOGO=GOGOGOGOGO=GOGOGOGOGO=tTGOGOGOGOGO=tTGOGOGOGOGO=tTGOGOGOGOGO=ZGOGOGOGOGO=gGOGOGOGOGO=N<GOGOGOGOGO=gGOGOGOGOGO=N<GOGOGOGOGO=tTGOGOGOGOGO=ZGOGOGOGOGO=gGOGOGOGOGO=ZGOGOGOGOGO=gGOGOGOGOGO=ZGOGOGOGOGO=AGOGOGOGOGO=ZGOGOGOGOGO=ZGOGOGOGOGO=AGOGOGOGOGO=tTGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGO=N<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=AGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=N<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=ZGOGOGOGOGOGOGOGOGOGOGOGOGOGO=N<  3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3          3          3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3              3GOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGO?UGOGO?GOGOGO?#GOGO?bGOGOGO?G+GOGO?p$GOGOGO?xGOGO?UGOGOGO>}GOGO?D9XGOGOGO?p;GOGO?GOGOGO?7$tGOGO?G+GOGOGO> GOGO=AGOGOGO=QN<GOGO=$tTGOGOGO<GOGO<gGOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO;o4GOGOGOGOGO;4GOGOGOGOGO;o4GOGOGOGOGO<3gGOGOGOGOGO<3gGOGOGOGOGO<3gGOGOGOGOGO<GOGOGOGOGO<o4GOGOGOGOGO<gGOGOGOGOGO<o4GOGOGOGOGO<gGOGOGOGOGO<3gGOGOGOGOGO<GOGOGOGOGO<o4GOGOGOGOGO<GOGOGOGOGO<o4GOGOGOGOGO<GOGOGOGOGO<N<GOGOGOGOGO<GOGOGOGOGO<GOGOGOGOGO<N<GOGOGOGOGO<3gGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGO<gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<o4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<N<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<o4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO;4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<GOGOGOGOGOGOGOGOGOGOGOGOGOGO<g  5  5   5  5   5  5   5  2   2  2   2  2   2  2   2  2   2  2   2  2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2     2          2          2                         2                         2                         2                         2                         2                         2                         2                         2                         2                         2                         2              2GOGO?GOGO@	GOGOGO?GOGO?GOGOGO?+GOGO?$GOGOGO?xGOGO?GOGOGO?v}GOGO?9XGOGOGO?p;GOGO?GOGOGO?$tGOGO?+GOGOGO>GOGO>`AGOGOGO=N<GOGO=tTGOGOGO=GOGO=3gGOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO;4GOGOGOGOGO<o4GOGOGOGOGO;4GOGOGOGOGO<gGOGOGOGOGO<gGOGOGOGOGO<gGOGOGOGOGO=GOGOGOGOGO<4GOGOGOGOGO=3gGOGOGOGOGO<4GOGOGOGOGO=3gGOGOGOGOGO<gGOGOGOGOGO=GOGOGOGOGO<4GOGOGOGOGO=GOGOGOGOGO<4GOGOGOGOGO=GOGOGOGOGO=QN<GOGOGOGOGO=GOGOGOGOGO=GOGOGOGOGO=QN<GOGOGOGOGO<gGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGO=3gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=QN<GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=3gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO<o4GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO=GOGOGOGOGOGOGOGOGOGOGOGOGOGO=3gGOGO;-TGOGO:2GOGOGO:ОGOGO:"GOGOGO:cGOGO:SGOGOGO:gGOGO:cGOGOGO:ZGOGO:SGOGOGO:UYGOGO:GOGOGO:GOGO:.DGOGOGO9^GOGO9GOGOGO9YGOGO9SGOGOGO9GOGO9G	GOGOGOGOGO9AGOGOGOGOGO9]lGOGOGOGOGO9kGOGOGOGOGO9xGGOGOGOGOGO9mGOGOGOGOGO9.\GOGOGOGOGO9ި
GOGOGOGOGO:SGOGOGOGOGO:KhGOGOGOGOGO:]GOGOGOGOGO:#GOGOGOGOGO:&@GOGOGOGOGO:&_GOGOGOGOGO:7&JGOGOGOGOGO:JGOGOGOGOGO:7
1GOGOGOGOGO:)ՔGOGOGOGOGO:bGOGOGOGOGO:GOGOGOGOGO:GOGOGOGOGO:GOGOGOGOGO:ӁGOGOGOGOGO:#/GOGOGOGOGO:9GOGOGOGOGO:	GOGOGOGOGO:GOGOGOGOGOGOGOGOGOGO9GOGOGOGOGOGOGOGOGOGO9|9GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9gGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9[ GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9cGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9.]GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9!GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9ǩGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9$GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9ڹGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9bGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO9GOGOGOGOGOGOGOGOGOGOGOGOGOGO9z  3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3   3  3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3     3          3          3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3                         3              3GOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGO    GOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGO    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO