% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbundle-add.R
\name{rbundle-add}
\alias{rbundle-add}
\alias{add_rschedule}
\alias{add_rdates}
\alias{add_exdates}
\title{Add to an rbundle}
\usage{
add_rschedule(x, rschedule)

add_rdates(x, rdates)

add_exdates(x, exdates)
}
\arguments{
\item{x}{\verb{[rbundle]}

An rbundle to add to.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule or rbundle.}

\item{rdates}{\verb{[Date]}

Dates to forcibly include in the rbundle.}

\item{exdates}{\verb{[Date]}

Dates to forcibly exclude from the rbundle.}
}
\value{
An updated rbundle.
}
\description{
\itemize{
\item \code{add_rschedule()} adds an rschedule to an rbundle. This can be another
rrule or another rbundle.
\item \code{add_rdates()} adds rdates to an rbundle. rdates are singular
special cased dates that are forcibly included in the event set.
\item \code{add_exdates()} adds exdates to an rbundle. exdates are singular
special cased dates that are forcibly excluded from the event set.
}
}
\details{
In terms of priority:
\itemize{
\item An exdate will never be included.
\item A rdate will always be included if it is not also an exdate.
\item An event generated from an rschedule will always be included if it is not
also an exdate.
}
}
\examples{
on_thanksgiving <- yearly() \%>\%
  recur_on_wday("Thurs", 4) \%>\%
  recur_on_ymonth("Nov")

on_christmas <- yearly() \%>\%
  recur_on_mday(25) \%>\%
  recur_on_ymonth("Dec")

on_labor_day <- monthly() \%>\%
  recur_on_ymonth("Sep") \%>\%
  recur_on_wday("Mon", 1)

rb <- runion() \%>\%
  add_rschedule(on_thanksgiving) \%>\%
  add_rschedule(on_christmas) \%>\%
  add_rschedule(on_labor_day)

# Thanksgiving, Christmas, or Labor Day
alma_search("2019-01-01", "2021-01-01", rb)

# Except Labor Day in 2019
rb2 <- add_exdates(rb, "2019-09-02")

alma_search("2019-01-01", "2021-01-01", rb2)

}
