% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vgaLocal.R
\name{vgaVisualLocal}
\alias{vgaVisualLocal}
\title{Visibility Graph Analysis - Visual local metrics}
\usage{
vgaVisualLocal(
  pointMap,
  nthreads = 1L,
  algorithm = VGALocalAlgorithm$Standard,
  copyMap = TRUE,
  gatesOnly = FALSE,
  progress = FALSE
)
}
\arguments{
\item{pointMap}{A PointMap}

\item{nthreads}{Optional. Number of threads to use (defaults to 1)}

\item{algorithm}{Optional. The algorithm to use. See ?VGALocalAlgorithm}

\item{copyMap}{Optional. Copy the internal sala map}

\item{gatesOnly}{Optional. Only keep the values at specific gates}

\item{progress}{Optional. Enable progress display}
}
\value{
A new PointMap with the results included
}
\description{
Runs Visibility Graph Analysis to get visual local metrics
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
vgaVisualLocal(pointMap, FALSE)
}
