% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapegraphToGraphData.R
\name{shapegraphToGraphData}
\alias{shapegraphToGraphData}
\title{Conversion of shapegraph to graph data}
\usage{
shapegraphToGraphData(shapeGraph, weightColumn = NA)
}
\arguments{
\item{shapeGraph}{A ShapeGraph}

\item{weightColumn}{Optional. The variable used to assign weight to graph edges}
}
\value{
Returns a list with edges and vertices for constructing a graph.
}
\description{
Creates data to be construct a graph, based on the connections and the x,y
coordinates of the centroids of shapes in a shapegraph (axial, segment,
convex). Specify weightColumn to assign weight to graph edges.
}
\details{
If weightColumn is provided, edge connections weight is calculated by taking
the average of the variable of the connected nodes.
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
shapegraphToGraphData(shapeGraph)
}
