% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneToOneTraverse.R
\name{oneToOneTraverse}
\alias{oneToOneTraverse}
\title{One-to-one traversal}
\usage{
oneToOneTraverse(
  map,
  traversalType,
  fromX,
  fromY,
  toX,
  toY,
  quantizationWidth = NA,
  copyMap = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{map}{A PointMap or Segment ShapeGraph}

\item{traversalType}{The traversal type. See \link{TraversalType}}

\item{fromX}{X coordinate of the point(s) to start the traversal from}

\item{fromY}{X coordinate of the point(s) to start the traversal from}

\item{toX}{X coordinate of the point(s) to start the traversal from}

\item{toY}{X coordinate of the point(s) to start the traversal from}

\item{quantizationWidth}{Set this to use chunks of this width instead of
continuous values for the cost of traversal. This is equivalent to the "tulip
bins" for depthmapX's tulip analysis (1024 tulip bins = pi/1024
quantizationWidth). Only works for Segment ShapeGraphs}

\item{copyMap}{Optional. Copy the internal sala map}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
Returns a list with:
\itemize{
  \item{completed: Whether the analysis completed}
  \item{newAttributes: The new attributes that were created during the
  process}
}
}
\description{
Runs one-to-one traversal on a map with a graph. This is applicable to:
\itemize{
  \item{PointMaps (Visibility Graph Analysis)}
  \item{Segment ShapeGraphs (Segment analysis)}
}
}
\examples{
# Pointmap analysis (VGA)
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
oneToOneTraverse(
  pointMap,
  traversalType = TraversalType$Metric,
  fromX = 7.52,
  fromY = 6.02,
  toX = 5.78,
  toY = 2.96
)

# Segment analysis
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_segment_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "SegmentShapeGraph")
oneToOneTraverse(
  shapeGraph,
  traversalType = TraversalType$Topological,
  fromX = 1217.1,
  fromY = -1977.3,
  toX = 1017.8,
  toY = -1699.3
)
}
