% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegmentShapeGraph.R
\name{axialToSegmentShapeGraph}
\alias{axialToSegmentShapeGraph}
\title{Axial to Segment ShapeGraph}
\usage{
axialToSegmentShapeGraph(axialShapeGraph, stubRemoval = NULL)
}
\arguments{
\item{axialShapeGraph}{An Axial ShapeGraph}

\item{stubRemoval}{Remove stubs of axial lines shorter than this
percentage (for example provide 0.4 for 40\%)}
}
\value{
A new Segment ShapeGraph
}
\description{
Convert an Axial ShapeGraph to a Segment ShapeGraph
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
axialToSegmentShapeGraph(shapeGraph, stubRemoval = 0.4)
}
