% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_log.R
\name{read_loss_log}
\alias{read_loss_log}
\title{Function for reading a log file containing a record of the loss during training.}
\usage{
read_loss_log(path_loss)
}
\arguments{
\item{path_loss}{\code{string} Path to the log file.}
}
\value{
Function returns a \code{matrix} that contains two or three row depending on
the data inside the loss log. In the case of two rows the first represents the
training data and the second the validation data. In the case of three rows
the third row represents the values for test data. All Columns represent the
epochs.
}
\description{
This function reads a log file that contains values for every epoch for the loss.
The values are grouped for training and validation data. The log contains
values for test data if test data was available during training.
}
\details{
In general the loss is written by a python function during model's training.
}
\seealso{
Other Utils Log Developers: 
\code{\link{cat_message}()},
\code{\link{clean_pytorch_log_transformers}()},
\code{\link{output_message}()},
\code{\link{print_message}()},
\code{\link{read_log}()},
\code{\link{reset_log}()},
\code{\link{reset_loss_log}()},
\code{\link{write_log}()}
}
\concept{Utils Log Developers}
