% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEClassifierRegular.R
\name{TEClassifierRegular}
\alias{TEClassifierRegular}
\title{Text embedding classifier with a neural net}
\value{
Objects of this class are used for assigning texts to classes/categories. For the creation and training of a
classifier an object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} on the one hand and a \link{factor} on
the other hand are necessary.

The object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}  contains the numerical text representations
(text embeddings) of the raw texts generated by an object of class \link{TextEmbeddingModel}. For supporting large data
sets it is recommended to use \link{LargeDataSetForTextEmbeddings} instead of \link{EmbeddedText}.

The \code{factor} contains the classes/categories for every text. Missing values (unlabeled cases) are supported and can
be used for pseudo labeling.

For predictions an object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings} has to be used which was
created with the same \link{TextEmbeddingModel} as for training.
}
\description{
Abstract class for neural nets with 'keras'/'tensorflow' and ' pytorch'.
}
\seealso{
Other Classification: 
\code{\link{TEClassifierProtoNet}}
}
\concept{Classification}
\section{Super class}{
\code{\link[aifeducation:AIFEBaseModel]{aifeducation::AIFEBaseModel}} -> \code{TEClassifierRegular}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature_extractor}}{('list()')\cr
List for storing information and objects about the feature_extractor.}

\item{\code{reliability}}{('list()')\cr

List for storing central reliability measures of the last training.
\itemize{
\item \code{reliability$test_metric}: Array containing the reliability measures for the test data for
every fold and step (in case of pseudo-labeling).
\item \code{reliability$test_metric_mean}: Array containing the reliability measures for the test data.
The values represent the mean values for every fold.
\item \code{reliability$raw_iota_objects}: List containing all iota_object generated with the package \code{iotarelr}
for every fold at the end of the last training for the test data.
\item \code{reliability$raw_iota_objects$iota_objects_end}: List of objects with class \code{iotarelr_iota2} containing the
estimated iota reliability of the second generation for the final model for every fold for the test data.
\item \code{reliability$raw_iota_objects$iota_objects_end_free}: List of objects with class \code{iotarelr_iota2} containing
the estimated iota reliability of the second generation for the final model for every fold for the test data.
Please note that the model is estimated without forcing the Assignment Error Matrix to be in line with the
assumption of weak superiority.
\item \code{reliability$iota_object_end}: Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold for the test data.
\item \code{reliability$iota_object_end_free}: Object of class \code{iotarelr_iota2} as a mean of the individual objects
for every fold. Please note that the model is estimated without forcing the Assignment Error Matrix to be in
line with the assumption of weak superiority.
\item \code{reliability$standard_measures_end}: Object of class \code{list} containing the final measures for precision,
recall, and f1 for every fold.
\item \code{reliability$standard_measures_mean}: \code{matrix} containing the mean measures for precision, recall, and f1.
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TEClassifierRegular-configure}{\code{TEClassifierRegular$configure()}}
\item \href{#method-TEClassifierRegular-train}{\code{TEClassifierRegular$train()}}
\item \href{#method-TEClassifierRegular-predict}{\code{TEClassifierRegular$predict()}}
\item \href{#method-TEClassifierRegular-check_embedding_model}{\code{TEClassifierRegular$check_embedding_model()}}
\item \href{#method-TEClassifierRegular-check_feature_extractor_object_type}{\code{TEClassifierRegular$check_feature_extractor_object_type()}}
\item \href{#method-TEClassifierRegular-requires_compression}{\code{TEClassifierRegular$requires_compression()}}
\item \href{#method-TEClassifierRegular-save}{\code{TEClassifierRegular$save()}}
\item \href{#method-TEClassifierRegular-load_from_disk}{\code{TEClassifierRegular$load_from_disk()}}
\item \href{#method-TEClassifierRegular-clone}{\code{TEClassifierRegular$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="count_parameter"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-count_parameter'><code>aifeducation::AIFEBaseModel$count_parameter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_all_fields"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_all_fields'><code>aifeducation::AIFEBaseModel$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_documentation_license'><code>aifeducation::AIFEBaseModel$get_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_ml_framework"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_ml_framework'><code>aifeducation::AIFEBaseModel$get_ml_framework()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_description'><code>aifeducation::AIFEBaseModel$get_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_info'><code>aifeducation::AIFEBaseModel$get_model_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_model_license'><code>aifeducation::AIFEBaseModel$get_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_package_versions"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_package_versions'><code>aifeducation::AIFEBaseModel$get_package_versions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_private"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_private'><code>aifeducation::AIFEBaseModel$get_private()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_publication_info'><code>aifeducation::AIFEBaseModel$get_publication_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_sustainability_data"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_sustainability_data'><code>aifeducation::AIFEBaseModel$get_sustainability_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_text_embedding_model"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_text_embedding_model'><code>aifeducation::AIFEBaseModel$get_text_embedding_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="get_text_embedding_model_name"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-get_text_embedding_model_name'><code>aifeducation::AIFEBaseModel$get_text_embedding_model_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="is_configured"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-is_configured'><code>aifeducation::AIFEBaseModel$is_configured()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="load"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-load'><code>aifeducation::AIFEBaseModel$load()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_documentation_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_documentation_license'><code>aifeducation::AIFEBaseModel$set_documentation_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_description"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_description'><code>aifeducation::AIFEBaseModel$set_model_description()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_model_license"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_model_license'><code>aifeducation::AIFEBaseModel$set_model_license()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic="AIFEBaseModel" data-id="set_publication_info"><a href='../../aifeducation/html/AIFEBaseModel.html#method-AIFEBaseModel-set_publication_info'><code>aifeducation::AIFEBaseModel$set_publication_info()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-configure"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-configure}{}}}
\subsection{Method \code{configure()}}{
Creating a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$configure(
  ml_framework = "pytorch",
  name = NULL,
  label = NULL,
  text_embeddings = NULL,
  feature_extractor = NULL,
  target_levels = NULL,
  dense_size = 4,
  dense_layers = 0,
  rec_size = 4,
  rec_layers = 2,
  rec_type = "gru",
  rec_bidirectional = FALSE,
  self_attention_heads = 0,
  intermediate_size = NULL,
  attention_type = "fourier",
  add_pos_embedding = TRUE,
  rec_dropout = 0.1,
  repeat_encoder = 1,
  dense_dropout = 0.4,
  recurrent_dropout = 0.4,
  encoder_dropout = 0.1,
  optimizer = "adam"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ml_framework}}{\code{string} Framework to use for training and inference. \code{ml_framework="tensorflow"} for
'tensorflow' and \code{ml_framework="pytorch"} for 'pytorch'}

\item{\code{name}}{\code{string} Name of the new classifier. Please refer to common name conventions. Free text can be used
with parameter \code{label}.}

\item{\code{label}}{\code{string} Label for the new classifier. Here you can use free text.}

\item{\code{text_embeddings}}{An object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{feature_extractor}}{Object of class \link{TEFeatureExtractor} which should be used in order to reduce the number
of dimensions of the text embeddings. If no feature extractor should be applied set \code{NULL}.}

\item{\code{target_levels}}{\code{vector} containing the levels (categories or classes) within the target data. Please not
that order matters. For ordinal data please ensure that the levels are sorted correctly with later levels
indicating a higher category/class. For nominal data the order does not matter.}

\item{\code{dense_size}}{\code{int} Number of neurons for each dense layer.}

\item{\code{dense_layers}}{\code{int} Number of dense layers.}

\item{\code{rec_size}}{\code{int} Number of neurons for each recurrent layer.}

\item{\code{rec_layers}}{\code{int} Number of recurrent layers.}

\item{\code{rec_type}}{\code{string} Type of the recurrent layers. \code{rec_type="gru"} for Gated Recurrent Unit and
\code{rec_type="lstm"} for Long Short-Term Memory.}

\item{\code{rec_bidirectional}}{\code{bool} If \code{TRUE} a bidirectional version of the recurrent layers is used.}

\item{\code{self_attention_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only
relevant if \code{attention_type="multihead"}}

\item{\code{intermediate_size}}{\code{int} determining the size of the projection layer within a each transformer encoder.}

\item{\code{attention_type}}{\code{string} Choose the relevant attention type. Possible values are \code{fourier} and \code{multihead}. Please note
that you may see different values for a case for different input orders if you choose \code{fourier} on linux.}

\item{\code{add_pos_embedding}}{\code{bool} \code{TRUE} if positional embedding should be used.}

\item{\code{rec_dropout}}{\code{int} ranging between 0 and lower 1, determining the dropout between bidirectional recurrent
layers.}

\item{\code{repeat_encoder}}{\code{int} determining how many times the encoder should be added to the network.}

\item{\code{dense_dropout}}{\code{int} ranging between 0 and lower 1, determining the dropout between dense layers.}

\item{\code{recurrent_dropout}}{\code{int} ranging between 0 and lower 1, determining the recurrent dropout for each
recurrent layer. Only relevant for keras models.}

\item{\code{encoder_dropout}}{\code{int} ranging between 0 and lower 1, determining the dropout for the dense projection
within the encoder layers.}

\item{\code{optimizer}}{\code{string} \code{"adam"} or \code{"rmsprop"} .}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class \link{TEClassifierRegular} which is ready for training.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-train"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-train}{}}}
\subsection{Method \code{train()}}{
Method for training a neural net.

Training includes a routine for early stopping. In the case that loss<0.0001
and Accuracy=1.00 and Average Iota=1.00 training stops. The history uses the values
of the last trained epoch for the remaining epochs.

After training the model with the best values for Average Iota, Accuracy, and Loss
on the validation data set is used as the final model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$train(
  data_embeddings,
  data_targets,
  data_folds = 5,
  data_val_size = 0.25,
  balance_class_weights = TRUE,
  balance_sequence_length = TRUE,
  use_sc = TRUE,
  sc_method = "dbsmote",
  sc_min_k = 1,
  sc_max_k = 10,
  use_pl = TRUE,
  pl_max_steps = 3,
  pl_max = 1,
  pl_anchor = 1,
  pl_min = 0,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  epochs = 40,
  batch_size = 32,
  dir_checkpoint,
  trace = TRUE,
  ml_trace = 1,
  log_dir = NULL,
  log_write_interval = 10,
  n_cores = auto_n_cores()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_embeddings}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{data_targets}}{\code{factor} containing the labels for cases stored in \code{data_embeddings}. Factor must be named
and has to use the same names used in \code{data_embeddings}.}

\item{\code{data_folds}}{\code{int} determining the number of cross-fold samples.}

\item{\code{data_val_size}}{\code{double} between 0 and 1, indicating the proportion of cases of each class which should be
used for the validation sample during the estimation of the model. The remaining cases are part of the training
data.}

\item{\code{balance_class_weights}}{\code{bool} If \code{TRUE} class weights are generated based on the frequencies of the
training data with the method Inverse Class Frequency'. If \code{FALSE} each class has the weight 1.}

\item{\code{balance_sequence_length}}{\code{bool} If \code{TRUE} sample weights are generated for the length of sequences based on
the frequencies of the training data with the method Inverse Class Frequency'. If \code{FALSE} each sequences length
has the weight 1.}

\item{\code{use_sc}}{\code{bool} \code{TRUE} if the estimation should integrate synthetic cases. \code{FALSE} if not.}

\item{\code{sc_method}}{\code{vector} containing the method for generating synthetic cases. Possible are \code{sc_method="adas"},
\code{sc_method="smote"}, and \code{sc_method="dbsmote"}.}

\item{\code{sc_min_k}}{\code{int} determining the minimal number of k which is used for creating synthetic units.}

\item{\code{sc_max_k}}{\code{int} determining the maximal number of k which is used for creating synthetic units.}

\item{\code{use_pl}}{\code{bool} \code{TRUE} if the estimation should integrate pseudo-labeling. \code{FALSE} if not.}

\item{\code{pl_max_steps}}{\code{int} determining the maximum number of steps during pseudo-labeling.}

\item{\code{pl_max}}{\code{double} between 0 and 1, setting the maximal level of confidence for considering a case for
pseudo-labeling.}

\item{\code{pl_anchor}}{\code{double} between 0 and 1 indicating the reference point for sorting the new cases of every
label. See notes for more details.}

\item{\code{pl_min}}{\code{double} between 0 and 1, setting the minimal level of confidence for considering a case for
pseudo-labeling.}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library
'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{\code{sustain_region}}{Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html}}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage.}

\item{\code{epochs}}{\code{int} Number of training epochs.}

\item{\code{batch_size}}{\code{int} Size of the batches for training.}

\item{\code{dir_checkpoint}}{\code{string} Path to the directory where the checkpoint during training should be saved. If the
directory does not exist, it is created.}

\item{\code{trace}}{\code{bool} \code{TRUE}, if information about the estimation phase should be printed to the console.}

\item{\code{ml_trace}}{\code{int} \code{ml_trace=0} does not print any information about the training process from pytorch on the
console.}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved. If no logging is desired set
this argument to \code{NULL}.}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update
the log files. Only relevant if \code{log_dir} is not \code{NULL}.}

\item{\code{n_cores}}{\code{int} Number of cores which should be used during the calculation of synthetic cases. Only relevant if
\code{use_sc=TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\itemize{
\item \code{sc_max_k}: All values from sc_min_k up to sc_max_k are successively used. If
the number of sc_max_k is too high, the value is reduced to a number that allows the calculating of synthetic
units.
\item \code{pl_anchor}: With the help of this value, the new cases are sorted. For
this aim, the distance from the anchor is calculated and all cases are arranged into an ascending order.
}
}

\subsection{Returns}{
Function does not return a value. It changes the object into a trained classifier.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-predict"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-predict}{}}}
\subsection{Method \code{predict()}}{
Method for predicting new data with a trained neural net.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$predict(newdata, batch_size = 32, ml_trace = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{Object of class \link{TextEmbeddingModel} or \link{LargeDataSetForTextEmbeddings} for which predictions
should be made. In addition, this method allows to use objects of class \code{array} and
\code{datasets.arrow_dataset.Dataset}. However, these should be used only by developers.}

\item{\code{batch_size}}{\code{int} Size of batches.}

\item{\code{ml_trace}}{\code{int} \code{ml_trace=0} does not print any information on the process from the machine learning
framework.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{data.frame} containing the predictions and the probabilities of the different labels for each
case.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-check_embedding_model"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-check_embedding_model}{}}}
\subsection{Method \code{check_embedding_model()}}{
Method for checking if the provided text embeddings are created with the same \link{TextEmbeddingModel}
as the classifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$check_embedding_model(
  text_embeddings,
  require_compressed = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text_embeddings}}{Object of class \link{EmbeddedText} or \link{LargeDataSetForTextEmbeddings}.}

\item{\code{require_compressed}}{\code{TRUE} if a compressed version of the embeddings are necessary. Compressed embeddings
are created by an object of class \link{TEFeatureExtractor}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the underlying \link{TextEmbeddingModel} is the same. \code{FALSE} if the models differ.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-check_feature_extractor_object_type"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-check_feature_extractor_object_type}{}}}
\subsection{Method \code{check_feature_extractor_object_type()}}{
Method for checking an object of class \link{TEFeatureExtractor}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$check_feature_extractor_object_type(feature_extractor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_extractor}}{Object of class \link{TEFeatureExtractor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does nothing returns. It raises an error if
\itemize{
\item the object is \code{NULL}
\item the object does not rely on the same machine learning framework as the classifier
\item the object is not trained.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-requires_compression"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-requires_compression}{}}}
\subsection{Method \code{requires_compression()}}{
Method for checking if provided text embeddings must be compressed via a \link{TEFeatureExtractor} before
processing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$requires_compression(text_embeddings)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text_embeddings}}{Object of class \link{EmbeddedText}, \link{LargeDataSetForTextEmbeddings}, \code{array} or
\code{datasets.arrow_dataset.Dataset}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Return \code{TRUE} if a compression is necessary and \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-save"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-save}{}}}
\subsection{Method \code{save()}}{
Method for saving a model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$save(dir_path, folder_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_path}}{\code{string} Path of the directory where the model should be saved.}

\item{\code{folder_name}}{\code{string} Name of the folder that should be created within the directory.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Function does not return a value. It saves the model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-load_from_disk"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-load_from_disk}{}}}
\subsection{Method \code{load_from_disk()}}{
loads an object from disk and updates the object to the current version of the package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$load_from_disk(dir_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_path}}{Path where the object set is stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Method does not return anything. It loads an object from disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TEClassifierRegular-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TEClassifierRegular-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TEClassifierRegular$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
