% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_joined.R
\name{derive_vars_joined}
\alias{derive_vars_joined}
\title{Add Variables from an Additional Dataset Based on Conditions from Both Datasets}
\usage{
derive_vars_joined(
  dataset,
  dataset_add,
  by_vars = NULL,
  order = NULL,
  new_vars = NULL,
  join_vars = NULL,
  filter_add = NULL,
  filter_join = NULL,
  mode = NULL,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by \code{by_vars} are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{new_vars}, the \code{join_vars},
and the \code{order} argument are expected.}

\item{by_vars}{Grouping variables

The two datasets are joined by the specified variables. Variables from the
additional dataset can be renamed by naming the element, i.e., \verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{order}{Sort order

If the argument is set to a non-null value, for each observation of the
input dataset the first or last observation from the joined dataset is
selected with respect to the specified order. The specified variables are
expected in the additional dataset (\code{dataset_add}). If a variable is
available in both \code{dataset} and \code{dataset_add}, the one from \code{dataset_add}
is used for the sorting.

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{exprs()}, e.g., \code{exprs(ADT, desc(AVAL))} or \code{NULL}}

\item{new_vars}{Variables to add

The specified variables from the additional dataset are added to the output
dataset. Variables can be renamed by naming the element, i.e., \verb{new_vars = exprs(<new name> = <old name>)}.

For example \code{new_vars = exprs(var1, var2)} adds variables \code{var1} and \code{var2}
from \code{dataset_add} to the input dataset.

And \code{new_vars = exprs(var1, new_var2 = old_var2)} takes \code{var1} and
\code{old_var2} from \code{dataset_add} and adds them to the input dataset renaming
\code{old_var2} to \code{new_var2}.

If the argument is not specified or set to \code{NULL}, all variables from the
additional dataset (\code{dataset_add}) are added.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{join_vars}{Variables to use from additional dataset

Any extra variables required from the additional dataset for \code{filter_join}
should be specified for this argument. Variables specified for \code{new_vars}
do not need to be repeated for \code{join_vars}. If a specified variable exists
in both the input dataset and the additional dataset, the suffix ".join" is
added to the variable from the additional dataset.

The variables are not included in the output dataset.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations from \code{dataset_add} fulfilling the specified condition are
joined to the input dataset. If the argument is not specified, all
observations are joined.

\emph{Permitted Values}: a condition}

\item{filter_join}{Filter for the joined dataset

The specified condition is applied to the joined dataset. Therefore
variables from both datasets \code{dataset} and \code{dataset_add} can be used.

\emph{Permitted Values}: a condition}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
argument is specified, \code{mode} must be non-null.

If the \code{order} argument is not specified, the \code{mode} argument is ignored.

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the (restricted) joined dataset are not unique
with respect to the by variables and the order.

This argument is ignored if \code{order} is not specified. In this case an error
is issued independent of \code{check_type} if the restricted joined dataset
contains more than one observation for any of the observations of the input
dataset.

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variables specified for \code{new_vars} from
the additional dataset (\code{dataset_add}).
}
\description{
The function adds variables from an additional dataset to the input dataset.
The selection of the observations from the additional dataset can depend on
variables from both datasets. For example, add the lowest value (nadir)
before the current observation.
}
\details{
\enumerate{
\item The records from the additional dataset (\code{dataset_add}) are restricted
to those matching the \code{filter_add} condition.
\item The input dataset and the (restricted) additional dataset are left
joined by the grouping variables (\code{by_vars}). If no grouping variables are
specified, a full join is performed.
\item The joined dataset is restricted by the \code{filter_join} condition.
\item If \code{order} is specified, for each observation of the input dataset the
first or last observation (depending on \code{mode}) is selected.
\item The variables specified for \code{new_vars} are renamed (if requested) and
merged to the input dataset. I.e., the output dataset contains all
observations from the input dataset. For observations without a matching
observation in the joined dataset the new variables are set to \code{NA}.
Observations in the additional dataset which have no matching observation
in the input dataset are ignored.
}
}
\examples{
library(tibble)
library(lubridate)
library(dplyr, warn.conflicts = FALSE)
library(tidyr)

# Add AVISIT (based on time windows), AWLO, and AWHI
adbds <- tribble(
  ~USUBJID, ~ADY,
  "1",       -33,
  "1",        -2,
  "1",         3,
  "1",        24,
  "2",        NA,
)

windows <- tribble(
  ~AVISIT,    ~AWLO, ~AWHI,
  "BASELINE",   -30,     1,
  "WEEK 1",       2,     7,
  "WEEK 2",       8,    15,
  "WEEK 3",      16,    22,
  "WEEK 4",      23,    30
)

derive_vars_joined(
  adbds,
  dataset_add = windows,
  filter_join = AWLO <= ADY & ADY <= AWHI
)

# derive the nadir after baseline and before the current observation
adbds <- tribble(
  ~USUBJID, ~ADY, ~AVAL,
  "1",        -7,    10,
  "1",         1,    12,
  "1",         8,    11,
  "1",        15,     9,
  "1",        20,    14,
  "1",        24,    12,
  "2",        13,     8
)

derive_vars_joined(
  adbds,
  dataset_add = adbds,
  by_vars = exprs(USUBJID),
  order = exprs(AVAL),
  new_vars = exprs(NADIR = AVAL),
  join_vars = exprs(ADY),
  filter_add = ADY > 0,
  filter_join = ADY.join < ADY,
  mode = "first",
  check_type = "none"
)

# add highest hemoglobin value within two weeks before AE,
# take earliest if more than one
adae <- tribble(
  ~USUBJID, ~ASTDY,
  "1",           3,
  "1",          22,
  "2",           2
)

adlb <- tribble(
  ~USUBJID, ~PARAMCD, ~ADY, ~AVAL,
  "1",      "HGB",       1,   8.5,
  "1",      "HGB",       3,   7.9,
  "1",      "HGB",       5,   8.9,
  "1",      "HGB",       8,   8.0,
  "1",      "HGB",       9,   8.0,
  "1",      "HGB",      16,   7.4,
  "1",      "HGB",      24,   8.1,
  "1",      "ALB",       1,    42,
)

derive_vars_joined(
  adae,
  dataset_add = adlb,
  by_vars = exprs(USUBJID),
  order = exprs(AVAL, desc(ADY)),
  new_vars = exprs(HGB_MAX = AVAL, HGB_DY = ADY),
  filter_add = PARAMCD == "HGB",
  filter_join = ASTDY - 14 <= ADY & ADY <= ASTDY,
  mode = "last"
)

# Add APERIOD, APERIODC based on ADSL
adsl <- tribble(
  ~USUBJID, ~AP01SDT,     ~AP01EDT,     ~AP02SDT,     ~AP02EDT,
  "1",      "2021-01-04", "2021-02-06", "2021-02-07", "2021-03-07",
  "2",      "2021-02-02", "2021-03-02", "2021-03-03", "2021-04-01"
) \%>\%
  mutate(across(ends_with("DT"), ymd)) \%>\%
  mutate(STUDYID = "xyz")

period_ref <- create_period_dataset(
  adsl,
  new_vars = exprs(APERSDT = APxxSDT, APEREDT = APxxEDT)
)

period_ref

adae <- tribble(
  ~USUBJID, ~ASTDT,
  "1",      "2021-01-01",
  "1",      "2021-01-05",
  "1",      "2021-02-05",
  "1",      "2021-03-05",
  "1",      "2021-04-05",
  "2",      "2021-02-15",
) \%>\%
  mutate(
    ASTDT = ymd(ASTDT),
    STUDYID = "xyz"
  )

derive_vars_joined(
  adae,
  dataset_add = period_ref,
  by_vars = exprs(STUDYID, USUBJID),
  join_vars = exprs(APERSDT, APEREDT),
  filter_join = APERSDT <= ASTDT & ASTDT <= APEREDT
)
}
\seealso{
General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_transposed}()},
\code{\link{get_summary_records}()}
}
\concept{der_gen}
\keyword{der_gen}
