% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utils.R
\name{convert_blanks_to_na}
\alias{convert_blanks_to_na}
\alias{convert_blanks_to_na.default}
\alias{convert_blanks_to_na.character}
\alias{convert_blanks_to_na.list}
\alias{convert_blanks_to_na.data.frame}
\title{Convert Blank Strings Into NAs}
\usage{
convert_blanks_to_na(x)

\method{convert_blanks_to_na}{default}(x)

\method{convert_blanks_to_na}{character}(x)

\method{convert_blanks_to_na}{list}(x)

\method{convert_blanks_to_na}{data.frame}(x)
}
\arguments{
\item{x}{Any R object}
}
\value{
An object of the same class as the input
}
\description{
Turn SAS blank strings into proper R \code{NA}s.
}
\details{
The default methods simply returns its input unchanged. The \code{character} method
turns every instance of \code{""} into \code{NA_character_} while preserving \emph{all} attributes.
When given a data frame as input the function keeps all non-character columns
as is and applies the just described logic to \code{character} columns. Once again
all attributes such as labels are preserved.
}
\examples{
library(tibble)

convert_blanks_to_na(c("a", "b", "", "d", ""))

df <- tibble(
  a = structure(c("a", "b", "", "c"), label = "A"),
  b = structure(c(1, NA, 21, 9), label = "B"),
  c = structure(c(TRUE, FALSE, TRUE, TRUE), label = "C"),
  d = structure(c("", "", "s", "q"), label = "D")
)
print(df)
convert_blanks_to_na(df)
}
\seealso{
Utilities for Formatting Observations: 
\code{\link{convert_na_to_blanks}()},
\code{\link{yn_to_numeric}()}
}
\concept{utils_fmt}
\keyword{utils_fmt}
