% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_merge.R
\name{transcripts_merge}
\alias{transcripts_merge}
\title{Merge several transcripts}
\usage{
transcripts_merge(
  trans_destination,
  trans_updates,
  identifier_tier = "update",
  identifier_intervall = ".+",
  erase_update_sections_completely = TRUE
)
}
\arguments{
\item{trans_destination}{Transcript object; transcript that serves as destination (and will receive the updates).}

\item{trans_updates}{List of transcript objects; transcript objects that will be inserted into the destination transcripts (entirely or in part).}

\item{identifier_tier}{Character string;  regular expression that identifies tier (in all trans_updates) in which the sections that will be inserted into trans_destination are marked.}

\item{identifier_intervall}{Character string; regular expression that identifies  (in trans_updates) the sections that will be inserted into trans_destination.}

\item{erase_update_sections_completely}{Logical; if \code{TRUE} update sections in destination transcript will be erased completely, if \code{FALSE} update sections in the destination tier will not be erased completely but only the tiers that are present in the trans_updates be erased.}
}
\value{
Transcript object
}
\description{
Merges several transcripts. One transcript is the destination transcript (the transcript that will be updated). 
The other transcripts are the update transcripts and contain the updates. 
The update transcripts need to contain a tier in which the update sections are marked.
}
\details{
You may chose between the following two options:
- The update sections in the destination transcript will first be erased completely and then the updates will be filled in.
- The update sections in the destination transcript will NOT be erased completely. Rater only the contents of tiers will be erased that are also present in the update tiers. e.g. if your destination transcript contains more tiers than the update transcripts, the contents of those tiers will be preserved in the destination tier during the update.
}
\examples{
library(act)

# We have three transcripts that to demonstrate the function \code{transcripts_merge}:
# - the destination transcript
trans_destination <- 	examplecorpus@transcripts[["update_destination"]]
# - two transcripts that contain updates
trans_updates <- 		c(examplecorpus@transcripts[["update_update1" ]],
                           examplecorpus@transcripts[["update_update2" ]])

# Run the function
test <- transcripts_merge(trans_destination, trans_updates)

# Save the transcript to a TextGrid file.
# Set the destination file path
path <- tempfile(pattern = "merge_test", tmpdir = tempdir(),
                 fileext = ".TextGrid")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                    paste(t@name, ".TextGrid", sep=""))
}

# Export
act::export_textgrid( t=test, outputPath=path)

}
