% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abe.R
\name{summary.abe}
\alias{summary.abe}
\title{Summary Function}
\usage{
\method{summary}{abe}(object, conf.level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{"abe"}, an object returned by a call to \code{\link{abe.boot}}}

\item{conf.level}{the confidence level, defaults to 0.95}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
a list with the following elements:

\code{var.rel.frequencies}: inclusion relative frequencies for all variables from the initial model

\code{model.rel.frequencies}: relative frequencies of the final models

\code{var.coefs}: bootstrap medians and percentiles for the estimates of the regression coefficients for each variable from the initial model
}
\description{
makes a summary of a bootstrapped version of ABE
}
\examples{
set.seed(1)
n=100
x1<-runif(n)
x2<-runif(n)
x3<-runif(n)
y<--5+5*x1+5*x2+ rnorm(n,sd=5)
dd<-data.frame(y=y,x1=x1,x2=x2,x3=x3)
fit<-lm(y~x1+x2+x3,x=TRUE,y=TRUE,data=dd)

fit.boot<-abe.boot(fit,data=dd,include="x1",active="x2",
tau=c(0.05,0.1),exp.beta=FALSE,exact=TRUE,
criterion="alpha",alpha=c(0.2,0.05),type.test="Chisq",
num.boot=50,type.boot="bootstrap")

summary(fit.boot)$var.rel.frequencies
}
\seealso{
\code{\link{abe.boot}}, \code{\link{plot.abe}}
}
\author{
Rok Blagus, \email{rok.blagus@mf.uni-lj.si}

Sladana Babic
}
