% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abe.R
\name{plot.abe}
\alias{plot.abe}
\title{Plot Function}
\usage{
\method{plot}{abe}(x, type.plot = c("coefficients", "models", "variables"),
  alpha = NULL, tau = NULL, variable = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{"abe"}, an object returned by a call to \code{\link{abe.boot}}}

\item{type.plot}{string which specifies the type of the plot. See details.}

\item{alpha}{values of alpha for which the plot is to be made (can be a vector of length >1)}

\item{tau}{values of tau for which the plot is to be made (can be a vector of length >1)}

\item{variable}{variables for which the plot is to be made (can be a vector of length >1)}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{barplot}}, \code{\link{hist}}).}
}
\description{
Plot function for the bootstrapped version of ABE.
}
\details{
when using \code{type.plot="coefficients"} the function plots a histogram of the estimated regression coefficients for the specified variables, alpha(s) and tau(s) obtained from different re-sampled datasets.
When the variable is not included in the final model, its regression coefficient is set to zero.
When using \code{type.plot="variables"} the function plots a barplot of the relative inclusion frequencies of the specified variables, for the specified values of alpha and tau.
When using \code{type.plot="models"} the function plots a barplot of the relative frequencies of the final models for specified alpha(s) and tau(s).
}
\examples{
set.seed(1)
n=100
x1<-runif(n)
x2<-runif(n)
x3<-runif(n)
y<--5+5*x1+5*x2+ rnorm(n,sd=5)
dd<-data.frame(y=y,x1=x1,x2=x2,x3=x3)
fit<-lm(y~x1+x2+x3,x=TRUE,y=TRUE,data=dd)

fit.boot<-abe.boot(fit,data=dd,include="x1",active="x2",
tau=c(0.05,0.1),exp.beta=FALSE,exact=TRUE,
criterion="alpha",alpha=c(0.2,0.05),type.test="Chisq",
num.boot=50,type.boot="bootstrap")

plot(fit.boot,type.plot="coefficients",
alpha=0.2,tau=0.1,variable=c("x1","x3"),
col="light blue")

plot(fit.boot,type.plot="variables",
alpha=0.2,tau=0.1,variable=c("x1","x2","x3"),
col="light blue",horiz=TRUE,las=1)

par(mar=c(4,6,4,2))
plot(fit.boot,type.plot="models",
alpha=0.2,tau=0.1,col="light blue",horiz=TRUE,las=1)
}
\seealso{
\code{\link{abe.boot}}, \code{\link{summary.abe}}
}
\author{
Rok Blagus, \email{rok.blagus@mf.uni-lj.si}

Sladana Babic
}
