% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourierKernel.R
\name{FourierKernel}
\alias{FourierKernel}
\title{Kernel matrix for Fourier basis}
\usage{
FourierKernel(x, M)
}
\arguments{
\item{x}{A vector in \eqn{[0,1]^n} for some \eqn{n}, containing the observations.}

\item{M}{The maximum frequency of Fourier basis functions to compute.}
}
\value{
The kernel matrix \eqn{K}, to be used in independence testing.
}
\description{
Calculates the kernel matrix, described in \insertCite{BKS2020}{USP} for
univariate continuous data when using the Fourier basis.
This function is used in USPFourier.
}
\examples{
n=10; x=runif(n)
FourierKernel(x,5)
}
\references{
\insertRef{BKS2020}{USP}
}
