% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicRNGFunction.R
\name{DynamicRNGFunction}
\alias{DynamicRNGFunction}
\title{A wrapper of random number generator.}
\usage{
DynamicRNGFunction(fn, ...)
}
\arguments{
\item{fn}{random number generator, e.g., rnorm, rchisq, etc. It can be
user-defined random number generator as well, e.g.,
PiecewiseConstantExponentialRNG}

\item{...}{arguments for \code{fn}. Specifying invalid arguments can trigger error and
be stopped. There are three exceptions. (1) \code{rng} can be passed through
`...` to give true name of \code{fn}. This could be necessary as it may be
hard to parse it accurately in \code{DynamicRNGFunction}, or simply for a more
informative purpose in some scenarios. (2) \code{var_name} can be passed
through `...` to specify the name of generated variable. (3) \code{simplify}
can be set to FALSE to convert a vector into a one-column data frame in returned
object. This happens for built-in random number generators, e.g., \code{rnorm},
\code{rbinom}, etc. These three arguments will not be passed into \code{fn}.}
}
\value{
a function to generate random number based on `fn` and arguments in
`...`. Specified arguments will be fixed and cannot be changed when invoking
`DynamicRNGFunction(fn, ...)()`. For example, if `foo <- DynamicRNGFunction(rnorm, sd = 2)`,
then `foo(n = 100)` will always generate data from normal distribution of
variance 4. `foo(n = 100, sd = 1)` will trigger an error. However,
if an argument is not specified in `DynamicRNGFunction`, then it can be specified
later. For example, `foo(n = 100, mean = -1)` will generate data from N(-1, 4).
}
\description{
A wrapper of random number generator.
}
\examples{
# example code
dfunc <- DynamicRNGFunction(rnorm, sd = 3.2)
x <- dfunc(1e3)
hist(x)

}
