% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-binomial.R
\name{util_binomial_param_estimate}
\alias{util_binomial_param_estimate}
\title{Estimate Binomial Parameters}
\usage{
util_binomial_param_estimate(.x, .size = NULL, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function. Must be numeric, and
all values must be 0 <= x <= 1}

\item{.size}{Number of trials, zero or more.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
This function will check to see if some given vector \code{.x} is
either a numeric vector or a factor vector with at least two levels then it
will cause an error and the function will abort. The function will return a
list output by default, and  if the parameter \code{.auto_gen_empirical} is set to
\code{TRUE} then the empirical data given to the parameter \code{.x} will be run through
the \code{tidy_empirical()} function and combined with the estimated binomial data.
}
\details{
This function will attempt to estimate the binomial p_hat and size
parameters given some vector of values.
}
\examples{
library(dplyr)
library(ggplot2)

tb <- rbinom(50, 1, .1)
output <- util_binomial_param_estimate(tb)

output$parameter_tbl

output$combined_data_tbl \%>\%
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_beta_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()}

Other Binomial: 
\code{\link{tidy_binomial}()},
\code{\link{tidy_negative_binomial}()},
\code{\link{tidy_zero_truncated_binomial}()},
\code{\link{tidy_zero_truncated_negative_binomial}()},
\code{\link{util_binomial_stats_tbl}()},
\code{\link{util_negative_binomial_param_estimate}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Binomial}
\concept{Parameter Estimation}
