% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTone.R
\name{powerTOSTone}
\alias{powerTOSTone}
\alias{powerTOSTone.raw}
\title{Power One Sample t-test}
\usage{
powerTOSTone(alpha, statistical_power, N, low_eqbound_d, high_eqbound_d)

powerTOSTone.raw(alpha, statistical_power, N, sd, low_eqbound, high_eqbound)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{statistical_power}{desired power (e.g., 0.8)}

\item{N}{sample size (e.g., 108)}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's d)}

\item{sd}{standard deviation.}

\item{low_eqbound}{lower equivalence bounds (e.g., -0.5) expressed in raw scores}

\item{high_eqbound}{upper equivalence bounds (e.g., 0.5) expressed in raw scores}
}
\value{
Calculate either achieved power, equivalence bounds, or required N, assuming a true effect size of 0.
Returns a string summarizing the power analysis, and a numeric variable for number of observations, equivalence bounds, or power.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Power analysis for TOST for one-sample t-test (Cohen's d).
This function is no longer maintained please use \link{power_t_TOST}.
}
\section{References}{

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition - CRC Press Book. Formula 3.1.9
}

\examples{
## Sample size for alpha = 0.05, 90\% power, equivalence bounds of
## Cohen's d = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTone(alpha=0.05, statistical_power=0.9, low_eqbound_d=-0.3, high_eqbound_d=0.3)

## Power for sample size of 121, alpha = 0.05, equivalence bounds of
## Cohen's d = -0.3 and Cohen's d = 0.3, and assuming true effect = 0

powerTOSTone(alpha=0.05, N=121, low_eqbound_d=-0.3, high_eqbound_d=0.3)

## Equivalence bounds for sample size of 121, alpha = 0.05, statistical power of
## 0.9, and assuming true effect d = 0

powerTOSTone(alpha=0.05, N=121, statistical_power=.9)

#' ## Sample size for alpha = 0.05, 90\% power, equivalence bounds of -0.3 and 0.3 in
## raw units, assuming pooled standard deviation of 1, and assuming true effect d = 0
powerTOSTone.raw(alpha=0.05, statistical_power=0.9, sd = 1, low_eqbound=-0.3, high_eqbound=0.3)

## Power for sample size of 121, alpha = 0.05, equivalence bounds of
## -0.3 and 0.3 in raw units, assuming pooled standard deviation of 1, and assuming true effect = 0

powerTOSTone.raw(alpha=0.05, N=121, sd = 1, low_eqbound=-0.3, high_eqbound=0.3)

## Power for sample size of 121, alpha = 0.05, statistical power of
## 0.9, and assuming true effect = 0

powerTOSTone.raw(alpha=0.05, N=121, statistical_power=.9, sd=1)
}
