% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_7.R
\name{get_case_lists}
\alias{get_case_lists}
\title{Retrieve All Case List Available for a Specific TCGA Study}
\usage{
get_case_lists(csid = "blca_tcga")
}
\arguments{
\item{csid}{String corresponding to the Identifier of the TCGA Study of Interest}
}
\value{
Data Frame including one row per case_list and five columns
}
\description{
TCGA keeps track of which samples were analyzed by which technique within a 
given Study. Sample identifiers are organized in lists of cases (samples/patients) 
and are associated with a case_list identifier. The function retrieves information 
about the case lists available for a given TCGA Study.
}
\examples{
blca_case_lists <- get_case_lists("blca_tcga")
blca_case_lists

}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
