% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.deps.R
\name{install.deps}
\alias{install.deps}
\title{Install Dependencies}
\usage{
install.deps(path = ".", ...)
}
\arguments{
\item{path}{a directory or file containing R code.}

\item{...}{passed to \code{install.packages}.}
}
\description{
Search R scripts for packages that are required and install those that are
not already installed. The default install location is the same as
\code{install.packages}.
}
\details{
This function also looks in the TAF boot directory for packages that are
required by the TAF boot process, i.e., called from a boot script.

In addition it runs taf.boot on SOFTWARE.bib to install any special packages that may not be available on CRAN.
}
\examples{
\dontrun{
# Download a TAF analysis
download(file.path("https://github.com/ices-taf/2019_san.sa.6",
                   "archive/refs/heads/master.zip"))
unzip("master.zip")
setwd("2019_san.sa.6-master")

# List dependencies
deps()
deps(taf.boot.path())

# Install dependencies that are not already installed
install.deps()
}

}
\seealso{
\code{\link{install.packages}} is the underlying function to install
packages.

\code{\link{deps}} searches R scripts for packages that are required.

\code{\link{TAF-package}} gives an overview of the package.
}
