% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bolognaTess}
\alias{bolognaTess}
\title{Municipalities' administrative borders for Bologna urban data.}
\format{
A \code{list} of three:
\itemize{
\item \code{tiles} a \code{list} of 11, each element is a \code{owin} object with the
administrative border of one municipality of Bologna's dataset
\item \code{n} the number of municipalities
\item \code{names} the names of the 11 municipalities, in the same order as the windows
}
}
\source{
EEA (2011). Corine land cover 2000 raster data. Technical Report, downloadable at
http://www.eea.europa.eu/data-and-maps/ data/corine-land-cover-2000-raster-1
}
\usage{
bolognaTess
}
\description{
City borders of all municipalities included in the Bologna dataset, in the format of polyognal windows \code{owin} objects.
}
\details{
The object contains a list of 11 observation windows created as \code{owin} objects based on the coordinates of the border polygons, for each municipality.
See \code{?owin} for details.
The object also contains the names of the municipalities, in Italian.
Examples on the usefulness of the administrative borders can be found at the topic \link{bologna}.
}
\examples{
data(bologna); data(bolognaW); data(bolognaTess)
plot(bolognaW, main="")
plot(bolognaTess$tiles[[1]],border=2, add=TRUE, lwd=2)
for(ll in 2:bolognaTess$n) plot(bolognaTess$tiles[[ll]],border=2, add=TRUE, lwd=2)

plot(as.im(bologna, W=bolognaW), main="", col=gray(c(0.85,0.4)), ribbon=FALSE)
plot(bolognaTess$tiles[[1]],border=1, add=TRUE, lwd=2)
for(ll in 2:bolognaTess$n) plot(bolognaTess$tiles[[ll]],border=1, add=TRUE, lwd=2)

#see examples under the topic "bologna"
}
\keyword{datasets}
