% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\docType{methods}
\name{changeObjEnv}
\alias{changeObjEnv}
\alias{changeObjEnv,character,environment,environment,logical-method}
\alias{changeObjEnv,character,environment,environment,missing-method}
\alias{changeObjEnv,character,environment,missing,logical-method}
\alias{changeObjEnv,character,environment,missing,missing-method}
\alias{changeObjEnv,character,missing,environment,logical-method}
\alias{changeObjEnv,character,missing,environment,missing-method}
\alias{changeObjEnv,list,ANY,ANY,ANY-method}
\title{Copy or move objects from one environment to another}
\usage{
changeObjEnv(x, toEnv, fromEnv, rmSrc)

\S4method{changeObjEnv}{character,environment,environment,logical}(x, toEnv,
  fromEnv, rmSrc)

\S4method{changeObjEnv}{character,environment,missing,missing}(x, toEnv)

\S4method{changeObjEnv}{character,missing,environment,missing}(x, fromEnv)

\S4method{changeObjEnv}{character,environment,missing,logical}(x, toEnv, rmSrc)

\S4method{changeObjEnv}{character,missing,environment,logical}(x, fromEnv,
  rmSrc)

\S4method{changeObjEnv}{character,environment,environment,missing}(x, toEnv,
  fromEnv)

\S4method{changeObjEnv}{list,ANY,ANY,ANY}(x, toEnv, fromEnv, rmSrc)
}
\arguments{
\item{x}{objects passed as character string vector}

\item{toEnv}{environment to copy or move to}

\item{fromEnv}{environment to copy or move from}

\item{rmSrc}{should the source copies of the objects be removed. Default is FALSE.}
}
\description{
This will copy or move (if \code{rmSrc=TRUE}) objects passed as a character
string to a different environment. This is used with a \code{spades} call to
copy or move objects to the \code{envir} environment object.
}
\examples{
e1 <- new.env()
e2 <- new.env()
assign("a1", 1:1e3, envir = e1)
assign("a2", 1:1e3, envir = e1)
objs <- c("a1", "a2")
# move objects between environments

changeObjEnv(objs, fromEnv = e1, toEnv = e2)

}
\author{
Eliot Mcintire
}

