% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AggregateExpression}
\alias{AggregateExpression}
\title{Aggregated feature expression by identity class}
\usage{
AggregateExpression(
  object,
  assays = NULL,
  features = NULL,
  return.seurat = FALSE,
  group.by = "ident",
  add.ident = NULL,
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{assays}{Which assays to use. Default is all assays}

\item{features}{Features to analyze. Default is all features in the assay}

\item{return.seurat}{Whether to return the data as a Seurat object. Default is FALSE}

\item{group.by}{Category (or vector of categories) for grouping (e.g, ident, replicate, celltype); 'ident' by default
To use multiple categories, specify a vector, such as c('ident', 'replicate', 'celltype')}

\item{add.ident}{(Deprecated). Place an additional label on each cell prior to pseudobulking}

\item{normalization.method}{Method for normalization, see \code{\link{NormalizeData}}}

\item{scale.factor}{Scale factor for normalization, see \code{\link{NormalizeData}}}

\item{margin}{Margin to perform CLR normalization, see \code{\link{NormalizeData}}}

\item{verbose}{Print messages and show progress bar}

\item{...}{Arguments to be passed to methods such as \code{\link{CreateSeuratObject}}}
}
\value{
Returns a matrix with genes as rows, identity classes as columns.
If return.seurat is TRUE, returns an object of class \code{\link{Seurat}}.
}
\description{
Returns summed counts ("pseudobulk") for each identity class.
}
\details{
If \code{return.seurat = TRUE}, aggregated values are placed in the 'counts'
layer of the returned object. The data is then normalized by running \code{\link{NormalizeData}}
on the aggregated counts. \code{\link{ScaleData}} is then run on the default assay
before returning the object.
}
\examples{
\dontrun{
data("pbmc_small")
head(AggregateExpression(object = pbmc_small)$RNA)
head(AggregateExpression(object = pbmc_small, group.by = c('ident', 'groups'))$RNA)
}

}
\concept{utilities}
