% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{PercentageFeatureSet}
\alias{PercentageFeatureSet}
\title{Calculate the percentage of all counts that belong to a given set of features}
\usage{
PercentageFeatureSet(
  object,
  pattern = NULL,
  features = NULL,
  col.name = NULL,
  assay = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{pattern}{A regex pattern to match features against}

\item{features}{A defined feature set. If features provided, will ignore the pattern matching}

\item{col.name}{Name in meta.data column to assign. If this is not null, returns a Seurat object
with the proportion of the feature set stored in metadata.}

\item{assay}{Assay to use}
}
\value{
Returns a vector with the proportion of the feature set or if md.name is set, returns a
Seurat object with the proportion of the feature set stored in metadata.
}
\description{
This function enables you to easily calculate the percentage of all the counts belonging to a
subset of the possible features for each cell. This is useful when trying to compute the percentage
of transcripts that map to mitochondrial genes for example. The calculation here is simply the
column sum of the matrix present in the counts slot for features belonging to the set divided by
the column sum for all features times 100.
}
\examples{
data("pbmc_small")
# Calculate the proportion of transcripts mapping to mitochondrial genes
# NOTE: The pattern provided works for human gene names. You may need to adjust depending on your
# system of interest
pbmc_small[["percent.mt"]] <- PercentageFeatureSet(object = pbmc_small, pattern = "^MT-")

}
\concept{utilities}
