% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{RunPCA}
\alias{RunPCA}
\alias{RunPCA.default}
\alias{RunPCA.Assay}
\alias{RunPCA.Seurat}
\title{Run Principal Component Analysis}
\usage{
RunPCA(object, ...)

\method{RunPCA}{default}(
  object,
  assay = NULL,
  npcs = 50,
  rev.pca = FALSE,
  weight.by.var = TRUE,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.key = "PC_",
  seed.use = 42,
  approx = TRUE,
  ...
)

\method{RunPCA}{Assay}(
  object,
  assay = NULL,
  features = NULL,
  npcs = 50,
  rev.pca = FALSE,
  weight.by.var = TRUE,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.key = "PC_",
  seed.use = 42,
  ...
)

\method{RunPCA}{Seurat}(
  object,
  assay = NULL,
  features = NULL,
  npcs = 50,
  rev.pca = FALSE,
  weight.by.var = TRUE,
  verbose = TRUE,
  ndims.print = 1:5,
  nfeatures.print = 30,
  reduction.name = "pca",
  reduction.key = "PC_",
  seed.use = 42,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods and IRLBA}

\item{assay}{Name of Assay PCA is being run on}

\item{npcs}{Total Number of PCs to compute and store (50 by default)}

\item{rev.pca}{By default computes the PCA on the cell x gene matrix. Setting
to true will compute it on gene x cell matrix.}

\item{weight.by.var}{Weight the cell embeddings by the variance of each PC
(weights the gene loadings if rev.pca is TRUE)}

\item{verbose}{Print the top genes associated with high/low loadings for
the PCs}

\item{ndims.print}{PCs to print genes for}

\item{nfeatures.print}{Number of genes to print for each PC}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names. PC by default}

\item{seed.use}{Set a random seed. By default, sets the seed to 42. Setting
NULL will not set a seed.}

\item{approx}{Use truncated singular value decomposition to approximate PCA}

\item{features}{Features to compute PCA on. If features=NULL, PCA will be run
using the variable features for the Assay. Note that the features must be present
in the scaled data. Any requested features that are not scaled or have 0 variance
will be dropped, and the PCA will be run using the remaining features.}

\item{reduction.name}{dimensional reduction name,  pca by default}
}
\value{
Returns Seurat object with the PCA calculation stored in the reductions slot
}
\description{
Run a PCA dimensionality reduction. For details about stored PCA calculation
parameters, see \code{PrintPCAParams}.
}
