% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_determination.R
\name{DBClustDimension}
\alias{DBClustDimension}
\title{Perform spectral density clustering on single cells}
\usage{
DBClustDimension(object, dim.1 = 1, dim.2 = 2, reduction.use = "tsne",
  G.use = NULL, set.ident = TRUE, seed.use = 1, ...)
}
\arguments{
\item{object}{Seurat object}

\item{dim.1}{First dimension to use}

\item{dim.2}{second dimension to use}

\item{reduction.use}{Which dimensional reduction to use (either 'pca' or 'ica')}

\item{G.use}{Parameter for the density clustering. Lower value to get more fine-scale clustering}

\item{set.ident}{TRUE by default. Set identity class to the results of the density clustering.
Unassigned cells (cells that cannot be assigned a cluster) are placed in cluster 1, if there are any.}

\item{seed.use}{Random seed for the dbscan function}

\item{...}{Additional arguments to be passed to the dbscan function}
}
\description{
Find point clounds single cells in a two-dimensional space using density clustering (DBSCAN).
}
\examples{
pbmc_small
# Density based clustering on the first two tSNE dimensions
pbmc_small <- DBClustDimension(pbmc_small)

}
