% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\encoding{UTF-8}
\name{geary}
\alias{geary}
\title{Geary's test for normality}
\usage{
geary(x, na.rm = TRUE)
}
\arguments{
\item{x}{the numeric vector.}

\item{na.rm}{A logical for NA values.}
}
\value{
statistic The Geary's test of statistic G.

p.value The significant probability of the null-hypothesis testing.
}
\description{
This function computes an estimator of Geary's measure of kurtosis.
}
\details{
Null hypothesis is that the data obeys to normal distribution and that data should have kurtosis equal to 3.
}
\examples{
set.seed(1234)
x = rnorm(1000)
geary(x)

geary(20:50)

y = c(0.269, 0.357, 0.2, 0.221, 0.275, 0.277, 0.253, 0.127, 0.246)
qqnorm(y)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}

