% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\name{time_vec}
\alias{time_vec}
\title{Format SWMP datetimestamp}
\usage{
time_vec(chr_in = NULL, station_code, tz_only = FALSE)
}
\arguments{
\item{chr_in}{chr string of datetimestamp vector}

\item{station_code}{is chr string for station (three or more characters)}

\item{tz_only}{logical that returns only the timezone, default \code{FALSE}}
}
\value{
Returns a POSIX vector if \code{tz_only} is true, otherwise the timezone for a station is returned as a chr string
}
\description{
Format the datetimestamp column of SWMP data
}
\details{
This function formats the datetimestamp column of SWMP data to the \code{\link[base]{POSIXct}} format and the correct timezone for a station.  Note that SWMP data do not include daylight savings and the appropriate location based on GMT offsets is used for formatting.  This function is used internally within data retrieval functions and does not need to be called explicitly.
}

