\name{gsslockedTrain}
\alias{gsslockedTrain}
\alias{gsslockedTrain0}
\alias{print.gsslockedTrain}
\alias{print.gsslockedTrain0}
\alias{summary.gsslockedTrain}
\alias{summary.gsslockedTrain0}
\alias{plot.gsslockedTrain}
\alias{plot.gsslockedTrain0}
\title{Function to Smooth a lockedTrain Object and Related Methods: The
  Smoothing Spline Approach}
\description{
  Smooths a \code{lockedTrain} object using a smoothing spline
  (\code{\link[gss]{gssanova}} or \code{\link[gss]{gssanova0}}) with the Poisson
  family after binning the object.
}
\usage{
gsslockedTrain(lockedTrain, bw = 0.001, ...)
gsslockedTrain0(lockedTrain, bw = 0.001, ...)
\method{print}{gsslockedTrain}(x, ...)
\method{print}{gsslockedTrain0}(x, ...)
\method{summary}{gsslockedTrain}(object, ...)
\method{summary}{gsslockedTrain0}(object, ...)
\method{plot}{gsslockedTrain}(x, xlab, ylab, main, xlim, ylim, col, lwd, ...)
\method{plot}{gsslockedTrain0}(x, xlab, ylab, main, xlim, ylim, col, lwd, ...)

}
\arguments{
  \item{lockedTrain}{a \code{\link{lockedTrain}} object.}
  \item{bw}{the bin width (in s) used to generate the observations on which
  the gss fit will be performed. See details below.}
  \item{x}{an \code{gsslockedTrain} or a \code{gsslockedTrain0} object.}
  \item{object}{an \code{gsslockedTrain} or a \code{gsslockedTrain0} object.}
  \item{xlim}{a numeric (default value supplied). See
    \code{\link{plot}}.}
  \item{ylim}{a numeric (default value supplied). See \code{\link{plot}}.}
  \item{xlab}{a character (default value supplied). See \code{\link{plot}}.}
  \item{ylab}{a character (default value supplied). See \code{\link{plot}}.}
  \item{main}{a character (default value supplied). See \code{\link{plot}}.}
  \item{lwd}{line width used to plot the estimated density. See \code{\link{plot}}.}
  \item{col}{color used to plot the estimated density. See \code{\link{plot}}.}
  \item{\dots}{in \code{gsslockedTrain}, respectively \code{gsslockedTrain0}, the
    \dots are passed to the internally called \code{\link[gss]{gssanova}}, repectively
    \code{\link[gss]{gssanova0}}. Not used in \code{print.gsslockedTrain} and
  \code{summary.gsslockedTrain} and their counterparts for
  \code{gsslockedTrain0} objects. Passed to \code{\link{plot}} in
  \code{plot.gsslockedTrain} and \code{plot.gsslockedTrain0}.}
}
\details{
  \code{gsslockedTrain} calls internally \code{\link[gss]{gssanova}} while
  \code{gsslockedTrain0} calls \code{\link[gss]{gssanova0}}. See the respective
  documentations and references therein for an explanation of the differences.
  \code{gsslockedTrain} and \code{gsslockedTrain0} essentially generate
  a smooth version of the
  histogram obtained by \code{\link{hist.lockedTrain}}. The Idea is to
  build the histogram first with a "too" small bin width before fitting
  a regression spline to it with a Poisson distribution of the observed
  counts.
}
\value{
  A list of class \code{gsslockedTrain}, respectively \code{gsslockedTrain0}, is returned by
  \code{gsslockedTrain}, respectively \code{gsslockedTrain0}. These
  lists have the following components:
  \item{gssFit }{the \code{gss} object generated by
    \code{\link[gss]{gssanova}} or \code{\link[gss]{gssanova0}}.}
  \item{Time }{the vector of bin centers.}
  \item{nRef }{the number of spikes in the reference train. See
    \code{\link{hist.lockedTrain}}.}
  \item{testFreq }{the mean frequency of the test neuron. See
    \code{\link{hist.lockedTrain}}.}
  \item{bwV }{the vector of bin widths used.}
  \item{CCH }{a logical which is \code{TRUE} if a cross-intensity was
    estimated and \code{FALSE} in the case of an auto-intensity.}
  \item{call }{the matched call.}

  \code{print.gsslockedTrain} returns the result of \code{\link[gss]{print.ssanova}}
  applied to the \code{gssanova} object generated by \code{gsslockedTrain}
  and stored in the the component \code{gssFit} of its argument. The
  same goes for \code{print.gsslockedTrain0}. 

  \code{summary.gsslockedTrain} returns the result of \code{\link[gss]{summary.gssanova}}
  applied to the \code{gssanova} object generated by \code{gsspsth}
  and stored in the component \code{gssFit} of its argument. The
  same goes for \code{summary.gsslockedTrain0}. 

}
\references{
  Gu C. (2002) \emph{Smoothing Spline ANOVA Models}. Springer.
}
\author{Christophe Pouzat \email{christophe.pouzat@gmail.com} }
\seealso{
  \code{\link{lockedTrain}},
  \code{\link{plot.lockedTrain}},
  \code{\link[gss]{gssanova}},
  \code{\link[gss]{gssanova0}}
}
\examples{
## load e070528spont data set
data(e070528spont)
## create a lockedTrain object with neuron 1 as reference
## and neuron 3 as test up to lags of +/- 250 ms
lt1.3 <- lockedTrain(e070528spont[[1]],e070528spont[[3]],laglim=c(-1,1)*0.25)
## look at the cross raster plot
lt1.3
## build a histogram of it using a 10 ms bin width
hist(lt1.3,bw=0.01)
## do it the smooth way
slt1.3 <- gsslockedTrain(lt1.3)
plot(slt1.3)
## do some check on the gss fit
summary(slt1.3)

## do the same with gsslockedTrain0
slt1.3 <- gsslockedTrain0(lt1.3)
plot(slt1.3)
## do some check on the gss fit
summary(slt1.3)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}
\keyword{smooth}
\keyword{regression}
