% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extend0rnd1.R
\name{Extend0rnd1}
\alias{Extend0rnd1}
\alias{Extend0rnd2}
\alias{Extend0rnd1b}
\title{varGroups-attribute to Extend0, Example functions}
\usage{
Extend0rnd1(data, varGroups, k = 1, rndSeed = 123)

Extend0rnd2(...)

Extend0rnd1b(...)
}
\arguments{
\item{data}{data.frame within \code{\link{Extend0}}}

\item{varGroups}{argument to \code{\link{Extend0}}}

\item{k}{Number of rows generated is approx. \code{k*nrow(data)}}

\item{rndSeed}{Internal random seed to be used}

\item{...}{Extra unused parameters}
}
\value{
a data frame
}
\description{
Setting \code{attr(varGroups, "FunctionExtend0")} to a function
makes \code{Extend0} behave differently
}
\details{
The point is to create a function that takes \code{data} and \code{varGroups} as input
and that returns a data frame with a limited number of combinations of the elements in \code{varGroups}.
The example function here is limited to two varGroups elements.
}
\examples{
z <- SSBtoolsData("sprt_emp_withEU")[c(1, 5, 8, 14), ]
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

varGroups <- list(c("year", "geo", "eu"), data.frame(age = c("middle", "old")))
Extend0(z, varGroups = varGroups)

attr(varGroups, "FunctionExtend0") <- Extend0rnd1
Extend0(z, varGroups = varGroups)

attr(varGroups, "FunctionExtend0") <- Extend0rnd1b
Extend0(z, varGroups = varGroups)

attr(varGroups, "FunctionExtend0") <- Extend0rnd2
Extend0(z, varGroups = varGroups)

# To see what's going on internally. Data used only via nrow 
varGroups <- list(data.frame(ab = rep(c("a", "b"), each = 4), abcd = c("a", "b", "c", "d")), 
                  data.frame(AB = rep(c("A", "B"), each = 3), ABC = c("A", "B", "C"))) 
a <- Extend0rnd1(data.frame(1:5), varGroups)
table(a[[1]], a[[2]])
table(a[[3]], a[[4]])
a <- Extend0rnd1b(data.frame(1:5), varGroups)
table(a[[1]], a[[2]])
table(a[[3]], a[[4]])
a <- Extend0rnd2(data.frame(1:5), varGroups[2:1])
table(a[[1]], a[[2]])
table(a[[3]], a[[4]])
a <- Extend0rnd1(data.frame(1:100), varGroups)
table(a[[1]], a[[2]]) # Maybe smaller numbers than expected since duplicates were removed
table(a[[3]], a[[4]])
}
