% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{plotParallel}
\alias{plotParallel}
\title{Parallel coordinate plot of a data set}
\usage{
plotParallel(
  result,
  xlab = NULL,
  ylab = NULL,
  yrange = NULL,
  splineFactor = 1,
  colorOption = "A",
  scale = "uniminmax",
  boxplot = FALSE,
  alphaLines = 0.1,
  showPoints = TRUE,
  title = "",
  probs = seq(0.25, 0.75, 0.25),
  ...
)
}
\arguments{
\item{result}{the result list returned by \code{\link[SPOT]{spot}},
importantly including the data \code{x}, \code{y}.}

\item{xlab}{character, the value of the independent variable}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{yrange}{a two-element vector that specifies the range of y values to consider (data outside of that range will be excluded).}

\item{splineFactor}{logical or numeric operator indicating whether spline interpolation should be used.
Numeric values will multiplied by the number of columns, TRUE will default to cubic interpolation,
AsIs to set the knot count directly and 0, FALSE, or non-numeric values will not use spline interpolation. See
\code{\link[GGally]{ggparcoord}}. Default: \code{"A"}.}

\item{colorOption}{A character string indicating the colormap
option to use. Four options are available:
"magma" (or "A"),
"inferno" (or "B"),
"plasma" (or "C"),
"viridis" (or "D", the default option) and
"cividis" (or "E"). See \code{\link[ggplot2]{scale_colour_viridis_d}}}

\item{scale}{method used to scale the variables. Default: \code{"uniminmax"}.}

\item{boxplot}{logical operator indicating whether or not boxplots should
underlay the distribution of each variable}

\item{alphaLines}{value of alpha scaler for the lines of the parcoord plot or
a column name of the data. Default: 0.1}

\item{showPoints}{logical operator indicating whether points
should be plotted or not. Default: TRUE}

\item{title}{character string denoting the title of the plot. Default:
\code{""}.}

\item{probs}{quantile probabilities. Default:  \code{seq(0, 1, 0.25)}}

\item{...}{additional parameters to be passed to
\code{\link[GGally]{ggparcoord}}.}
}
\value{
plotly parallel coordinate plot ('parcoords') visualization (based on
\code{\link[plotly]{plot_ly}})
}
\description{
Parallel plot based on \code{\link[GGally]{ggparcoord}}.
}
\examples{
\donttest{
require("SPOT")
res <- spot(x=NULL,
             funSphere,
             lower=rep(-1,3),
             upper=rep(1,3),
             control=list(funEvals=25))
plotParallel(res, scale="std")
}
}
\seealso{
\code{\link[SPOT]{plotFunction}}, \code{\link[SPOT]{plotData}}
}
