% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAR_all.R
\name{MAR_MTS_Covariance}
\alias{MAR_MTS_Covariance}
\title{A Funtion to generate a multivariate autoregressive process (MAR) model in
time series. It is used for testing change-points based on the change in multivariate
means or multivariate covariance for multivariate time series. It also works
for the change in correlations between two univariate time series.}
\usage{
MAR_MTS_Covariance(n, reptime, rho_sets, cp_sets, sigma_cross)
}
\arguments{
\item{n}{the size of time series to be generated.}

\item{reptime}{the number of time series to be generated.}

\item{rho_sets}{autocorrelations for each univariate time series.}

\item{cp_sets}{numeric values of the true change-point locations (0, change-point
locations and the end point).}

\item{sigma_cross}{a list of matrices to generate the multivariate covariance
matrices.}
}
\value{
Returns a list of matrices where each matrix is a MAR process. The
number of columns for each sub-matrix is equivalent to the value of input
argument \code{reptime}.
}
\description{
The function \code{MAR_MTS_Covariance} is used to generate MAR model(s) for
examples of the functions \code{SNSeg_Uni}, \code{SNSeg_Multi}, and \code{SNSeg_HD}.
}
\examples{
n <- 1000
reptime <- 2
sigma_cross <- list(4*matrix(c(1,0.8,0.8,1), nrow=2),
                      matrix(c(1,0.2,0.2,1), nrow=2),
                      matrix(c(1,0.8,0.8,1), nrow=2))
cp_sets <- round(c(0,n/3,2*n/3,n))
noCP <- length(cp_sets)-2
rho_sets <- rep(0.5, noCP+1)
MAR_MTS_Covariance(n, reptime, rho_sets, cp_sets, sigma_cross)

}
