% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/et.R
\name{.clearPipe}
\alias{.clearPipe}
\title{Clear/Set pipeline}
\usage{
.clearPipe(
  rx = NULL,
  inits = NULL,
  events = NULL,
  params = NULL,
  iCov = NULL,
  keep = NULL,
  thetaMat = NULL,
  omega = NULL,
  sigma = NULL,
  dfObs = NULL,
  dfSub = NULL,
  nSub = NULL,
  nStud = NULL
)
}
\arguments{
\item{rx}{RxODE object}

\item{inits}{a vector of initial values of the state variables
(e.g., amounts in each compartment), and the order in this
vector must be the same as the state variables (e.g., PK/PD
compartments);}

\item{events}{an \code{eventTable} object describing the input
(e.g., doses) to the dynamic system and observation sampling
time points (see \code{\link{eventTable}});}

\item{params}{a numeric named vector with values for every
parameter in the ODE system; the names must correspond to the
parameter identifiers used in the ODE specification;}

\item{iCov}{A data frame of individual non-time varying covariates
to combine with the \code{params} to form a parameter
data.frame.}

\item{keep}{Columns to keep from either the input dataset or the
\code{iCov} dataset.  With the \code{iCov} dataset, the column
is kept once per line.  For the input dataset, if any records
are added to the data LOCF (Last Observation Carried forward)
imputation is performed.}

\item{thetaMat}{Named theta matrix.}

\item{omega}{Estimate of Covariance matrix. When omega is a list,
assume it is a block matrix and convert it to a full matrix
for simulations.}

\item{sigma}{Named sigma covariance or Cholesky decomposition of a
covariance matrix.  The names of the columns indicate
parameters that are simulated.  These are simulated for every
observation in the solved system.}

\item{dfObs}{Degrees of freedom to sample the unexplained variability matrix from the 
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{dfSub}{Degrees of freedom to sample the between subject variability matrix from the 
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{nSub}{Number between subject variabilities (ETAs) simulated for every 
realization of the parameters.}

\item{nStud}{Number virtual studies to characterize uncertainty in estimated 
parameters.}
}
\description{
Clear/Set pipeline
}
\keyword{intenral}
